﻿using System.Configuration;
using System.Web.Configuration;

namespace Muban
{
    public class ConfigurationSection : System.Configuration.ConfigurationSection
    {
        [ConfigurationProperty("templateServiceType")]
        public string TemplateServiceType
        {
            get { return (string)this["templateServiceType"]; }
            set { this["templateServiceType"] = value; }
        }

        [ConfigurationProperty("compilerOptions")]
        public string CompilerOptions
        {
            get { return (string)this["compilerOptions"]; }
            set { this["compilerOptions"] = value; }
        }

        [ConfigurationProperty("assemblies")]
        public AssemblyCollection Assemblies
        {
            get { return (AssemblyCollection)this["assemblies"]; }
            set { this["assemblies"] = value; }
        }

        [ConfigurationProperty("namespaces")]
        public NamespaceCollection Namespaces
        {
            get { return (NamespaceCollection)this["namespaces"]; }
            set { this["namespaces"] = value; }
        }

        public static ConfigurationSection GetConfig(string sectionName = "muban")
        {
            return ConfigurationManager.GetSection(sectionName) as ConfigurationSection;
        }
    }
}
