﻿using System;
using System.IO;
using System.Web.Razor;

namespace Muban.Template
{
    public abstract class FileTemplate : TemplateBase, IFileTemplate
    {
        public virtual string Parse(string virtualPath, Action<object> activator = null)
        {
            return Parser.Parse(Path.Combine(Path.GetDirectoryName(this.FileName), virtualPath), base.GetType().BaseType, this.Language, activator ?? this.Activator);
        }

        public virtual string Parse(string virtualPath, RazorCodeLanguage language, Action<object> activator = null)
        {
            return Parser.Parse(Path.Combine(Path.GetDirectoryName(this.FileName), virtualPath), base.GetType().BaseType, language, activator ?? this.Activator);
        }

        public virtual string Include(string virtualPath)
        {
            return Parser.SERVICE.GetInclude(Path.Combine(Path.GetDirectoryName(this.FileName), virtualPath));
        }

        public virtual void Clear()
        {
            this.output.Clear();
        }

        public string FileName { get; internal set; }
    }
}