﻿using System;
using System.Web.Razor;

namespace Muban.Template
{
    public interface ITemplate
    {
        void Write(object value);
        void WriteLiteral(string value);
        void Execute();

        string Eval(string code, Action<object> activator = null);
        string Eval(string code, RazorCodeLanguage language, Action<object> activator = null);
        string ToString();

        Action<object> Activator { get; }
        RazorCodeLanguage Language { get; }
    }
}