﻿using System;
using System.Text;
using System.Web.Razor;

namespace Muban.Template
{
    public abstract class TemplateBase : ITemplate
    {
        internal StringBuilder output;

        public TemplateBase()
        {
            this.output = new StringBuilder();
        }

        public virtual void Write(object value)
        {
            this.output.Append(value);
        }

        public virtual void WriteLiteral(string value)
        {
            this.Write(value);
        }

        public string Eval(string code, Action<object> activator = null)
        {
            return Parser.Eval(code, base.GetType().BaseType, this.Language, activator ?? this.Activator);
        }

        public string Eval(string code, RazorCodeLanguage language, Action<object> activator = null)
        {
            return Parser.Eval(code, base.GetType().BaseType, language, activator ?? this.Activator);
        }

        public abstract void Execute();

        public override string ToString()
        {
            return this.output.ToString();
        }

        public Action<object> Activator { get; internal set; }
        public RazorCodeLanguage Language { get; internal set; }
    }
}
