﻿using System.Security.Principal;

namespace ynhtm.BLL
{
    /// <summary>
    /// 用户标识。
    /// </summary>
    public class Principal : GenericPrincipal, Model.IPrincipal
    {
        public Principal(IIdentity identity, string[] roles)
            : base(identity, roles) { }

        Model.User user = null;
        /// <summary>
        /// 当前用户的实例，没有则返回 null。
        /// </summary>
        public Model.User User
        {
            get
            {
                var id = this.Identity;
                if (!id.IsAuthenticated || id.AuthenticationType != "Forms") return null;
                if (this.user == null) this.user = DAL.User.GetByUserName(this.Identity.Name);
                return this.user;
            }
        }
    }
}