﻿using System;
using System.Data;
using System.Data.SqlClient;

namespace ynhtm.DAL
{
	using ynhtm.DBUtility;

    public static class JobTry
    {
		public const string TRYID = "TryID";
		public const string JOBID = "JobID";
		public const string REALNAME = "RealName";
		public const string SEX = "Sex";
		public const string WEDDING = "Wedding";
		public const string BDAY = "Bday";
		public const string SCHOOL = "School";
		public const string CONTACT = "Contact";
		public const string ADDR = "Addr";
		public const string EDUCATIONNOTE = "EducationNote";
		public const string WORKNOTE = "WorkNote";
		public const string REMARK = "Remark";
		public const string FILEURL = "FileUrl";
		public const string IPADDR = "IPAddr";
		public const string POSTDATE = "PostDate";

		public const string SQL_TABLE = "ynhtm_JobTry";
		public const string SQL_FIELD = "TryID,JobID,RealName,Sex,Wedding,Bday,School,Contact,Addr,EducationNote,WorkNote,Remark,FileUrl,IPAddr,PostDate";
		public const string SQL_SELECT = "SELECT TryID,JobID,RealName,Sex,Wedding,Bday,School,Contact,Addr,EducationNote,WorkNote,Remark,FileUrl,IPAddr,PostDate FROM ynhtm_JobTry";
		public const string SQL_INSERT = "INSERT INTO ynhtm_JobTry (JobID,RealName,Sex,Wedding,Bday,School,Contact,Addr,EducationNote,WorkNote,Remark,FileUrl,IPAddr) VALUES (@JobID,@RealName,@Sex,@Wedding,@Bday,@School,@Contact,@Addr,@EducationNote,@WorkNote,@Remark,@FileUrl,@IPAddr)";
		public const string SQL_UPDATE = "UPDATE ynhtm_JobTry SET ";
		public const string SQL_DELETE = "DELETE FROM ynhtm_JobTry";

        public static void FillItem(IDataReader reader, Model.IJobTry item)
        {
			item.TryID = reader.GetInt32(DAL.JobTry.TRYID);
			item.JobID = reader.GetInt32(DAL.JobTry.JOBID);
			item.RealName = reader.GetString(DAL.JobTry.REALNAME);
			if (!reader.IsDBNull(SEX)) item.Sex = reader.GetInt32(DAL.JobTry.SEX);
			if (!reader.IsDBNull(WEDDING)) item.Wedding = reader.GetInt32(DAL.JobTry.WEDDING);
			if (!reader.IsDBNull(BDAY)) item.Bday = reader.GetDateTime(DAL.JobTry.BDAY);
			if (!reader.IsDBNull(SCHOOL)) item.School = reader.GetString(DAL.JobTry.SCHOOL);
			item.Contact = reader.GetString(DAL.JobTry.CONTACT);
			if (!reader.IsDBNull(ADDR)) item.Addr = reader.GetString(DAL.JobTry.ADDR);
			if (!reader.IsDBNull(EDUCATIONNOTE)) item.EducationNote = reader.GetString(DAL.JobTry.EDUCATIONNOTE);
			if (!reader.IsDBNull(WORKNOTE)) item.WorkNote = reader.GetString(DAL.JobTry.WORKNOTE);
			if (!reader.IsDBNull(REMARK)) item.Remark = reader.GetString(DAL.JobTry.REMARK);
			if (!reader.IsDBNull(FILEURL)) item.FileUrl = reader.GetString(DAL.JobTry.FILEURL);
			item.IPAddr = reader.GetString(DAL.JobTry.IPADDR);
			item.PostDate = reader.GetDateTime(DAL.JobTry.POSTDATE);
        }

        public static void Insert(Model.JobTry item)
        {
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.JobTry.SQL_INSERT + ";" + db.IDentity, db.CreateParameter(DAL.JobTry.JOBID, item.JobID), db.CreateParameter(DAL.JobTry.REALNAME, item.RealName), db.CreateParameter(DAL.JobTry.SEX, item.Sex), db.CreateParameter(DAL.JobTry.WEDDING, item.Wedding), db.CreateParameter(DAL.JobTry.BDAY, item.Bday), db.CreateParameter(DAL.JobTry.SCHOOL, item.School), db.CreateParameter(DAL.JobTry.CONTACT, item.Contact), db.CreateParameter(DAL.JobTry.ADDR, item.Addr), db.CreateParameter(DAL.JobTry.EDUCATIONNOTE, item.EducationNote), db.CreateParameter(DAL.JobTry.WORKNOTE, item.WorkNote), db.CreateParameter(DAL.JobTry.REMARK, item.Remark), db.CreateParameter(DAL.JobTry.FILEURL, item.FileUrl), db.CreateParameter(DAL.JobTry.IPADDR, item.IPAddr)))
                {
                    if (reader.Read())
					{
						item.TryID = Convert.ToInt32(reader.GetValue(0));
					}
                }
            }
		}

		#region TryID

		public static Model.JobTry GetByTryID(int tryID)
		{
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.JobTry.SQL_SELECT + " WHERE " + DAL.JobTry.TRYID + " = @" + DAL.JobTry.TRYID, db.CreateParameter(DAL.JobTry.TRYID, tryID)))
                {
                    if (!reader.Read()) return null;
					var result = new Model.JobTry();
                    DAL.JobTry.FillItem(reader, result);
					return result;
                }
            }
		}

		public static int Update(Model.JobTry item)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.JobTry.SQL_UPDATE + " WHERE " + DAL.JobTry.TRYID + " = @" + DAL.JobTry.TRYID, db.CreateParameter(DAL.JobTry.TRYID, item.TryID));
		}

		public static int Delete(int tryID)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.JobTry.SQL_DELETE + " WHERE " + DAL.JobTry.TRYID + " = @" + DAL.JobTry.TRYID, db.CreateParameter(DAL.JobTry.TRYID, tryID));
		}

		#endregion
	}

    public static class Job
    {
		public const string JOBID = "JobID";
		public const string TYPE = "Type";
		public const string URL = "Url";
		public const string REWRITE = "Rewrite";
		public const string THEME = "Theme";
		public const string ENABLED = "Enabled";
		public const string VIEWCOUNT = "ViewCount";
		public const string TRYCOUNT = "TryCount";
		public const string NAME = "Name";
		public const string AREA = "Area";
		public const string COUNT = "Count";
		public const string SALARY = "Salary";
		public const string SEX = "Sex";
		public const string AGE = "Age";
		public const string DEGREE = "Degree";
		public const string EXPERIENCE = "Experience";
		public const string CONTENT = "Content";
		public const string ENDDATE = "EndDate";
		public const string CREATEDATE = "CreateDate";

		public const string SQL_TABLE = "ynhtm_Job";
		public const string SQL_FIELD = "JobID,Type,Url,Rewrite,Theme,Enabled,ViewCount,TryCount,Name,Area,Count,Salary,Sex,Age,Degree,Experience,Content,EndDate,CreateDate";
		public const string SQL_SELECT = "SELECT JobID,Type,Url,Rewrite,Theme,Enabled,ViewCount,TryCount,Name,Area,Count,Salary,Sex,Age,Degree,Experience,Content,EndDate,CreateDate FROM ynhtm_Job";
		public const string SQL_INSERT = "INSERT INTO ynhtm_Job (Type,Url,Rewrite,Theme,Enabled,ViewCount,TryCount,Name,Area,Count,Salary,Sex,Age,Degree,Experience,Content,EndDate) VALUES (@Type,@Url,@Rewrite,@Theme,@Enabled,@ViewCount,@TryCount,@Name,@Area,@Count,@Salary,@Sex,@Age,@Degree,@Experience,@Content,@EndDate)";
		public const string SQL_UPDATE = "UPDATE ynhtm_Job SET Type = @Type,Url = @Url,Rewrite = @Rewrite,Theme = @Theme,Enabled = @Enabled,Name = @Name,Area = @Area,Count = @Count,Salary = @Salary,Sex = @Sex,Age = @Age,Degree = @Degree,Experience = @Experience,Content = @Content,EndDate = @EndDate";
		public const string SQL_DELETE = "DELETE FROM ynhtm_Job";

        public static void FillItem(IDataReader reader, Model.IJob item)
        {
			item.JobID = reader.GetInt32(DAL.Job.JOBID);
			if (!reader.IsDBNull(TYPE)) item.Type = reader.GetInt32(DAL.Job.TYPE);
			item.Url = reader.GetString(DAL.Job.URL);
			if (!reader.IsDBNull(REWRITE)) item.Rewrite = reader.GetString(DAL.Job.REWRITE);
			if (!reader.IsDBNull(THEME)) item.Theme = reader.GetString(DAL.Job.THEME);
			item.Enabled = reader.GetBoolean(DAL.Job.ENABLED);
			item.ViewCount = reader.GetInt32(DAL.Job.VIEWCOUNT);
			item.TryCount = reader.GetInt32(DAL.Job.TRYCOUNT);
			item.Name = reader.GetString(DAL.Job.NAME);
			if (!reader.IsDBNull(AREA)) item.Area = reader.GetString(DAL.Job.AREA);
			if (!reader.IsDBNull(COUNT)) item.Count = reader.GetInt32(DAL.Job.COUNT);
			if (!reader.IsDBNull(SALARY)) item.Salary = reader.GetDecimal(DAL.Job.SALARY);
			if (!reader.IsDBNull(SEX)) item.Sex = reader.GetInt32(DAL.Job.SEX);
			if (!reader.IsDBNull(AGE)) item.Age = reader.GetInt32(DAL.Job.AGE);
			if (!reader.IsDBNull(DEGREE)) item.Degree = reader.GetInt32(DAL.Job.DEGREE);
			if (!reader.IsDBNull(EXPERIENCE)) item.Experience = reader.GetInt32(DAL.Job.EXPERIENCE);
			if (!reader.IsDBNull(CONTENT)) item.Content = reader.GetString(DAL.Job.CONTENT);
			if (!reader.IsDBNull(ENDDATE)) item.EndDate = reader.GetDateTime(DAL.Job.ENDDATE);
			item.CreateDate = reader.GetDateTime(DAL.Job.CREATEDATE);
        }

        public static void Insert(Model.Job item)
        {
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Job.SQL_INSERT + ";" + db.IDentity, db.CreateParameter(DAL.Job.TYPE, item.Type), db.CreateParameter(DAL.Job.URL, item.Url), db.CreateParameter(DAL.Job.REWRITE, item.Rewrite), db.CreateParameter(DAL.Job.THEME, item.Theme), db.CreateParameter(DAL.Job.ENABLED, item.Enabled), db.CreateParameter(DAL.Job.VIEWCOUNT, item.ViewCount), db.CreateParameter(DAL.Job.TRYCOUNT, item.TryCount), db.CreateParameter(DAL.Job.NAME, item.Name), db.CreateParameter(DAL.Job.AREA, item.Area), db.CreateParameter(DAL.Job.COUNT, item.Count), db.CreateParameter(DAL.Job.SALARY, item.Salary), db.CreateParameter(DAL.Job.SEX, item.Sex), db.CreateParameter(DAL.Job.AGE, item.Age), db.CreateParameter(DAL.Job.DEGREE, item.Degree), db.CreateParameter(DAL.Job.EXPERIENCE, item.Experience), db.CreateParameter(DAL.Job.CONTENT, item.Content), db.CreateParameter(DAL.Job.ENDDATE, item.EndDate)))
                {
                    if (reader.Read())
					{
						item.JobID = Convert.ToInt32(reader.GetValue(0));
					}
                }
            }
		}

		#region JobID

		public static Model.Job GetByJobID(int jobID)
		{
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Job.SQL_SELECT + " WHERE " + DAL.Job.JOBID + " = @" + DAL.Job.JOBID, db.CreateParameter(DAL.Job.JOBID, jobID)))
                {
                    if (!reader.Read()) return null;
					var result = new Model.Job();
                    DAL.Job.FillItem(reader, result);
					return result;
                }
            }
		}

		public static int Update(Model.Job item)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Job.SQL_UPDATE + " WHERE " + DAL.Job.JOBID + " = @" + DAL.Job.JOBID, db.CreateParameter(DAL.Job.JOBID, item.JobID), db.CreateParameter(DAL.Job.TYPE, item.Type), db.CreateParameter(DAL.Job.URL, item.Url), db.CreateParameter(DAL.Job.REWRITE, item.Rewrite), db.CreateParameter(DAL.Job.THEME, item.Theme), db.CreateParameter(DAL.Job.ENABLED, item.Enabled), db.CreateParameter(DAL.Job.NAME, item.Name), db.CreateParameter(DAL.Job.AREA, item.Area), db.CreateParameter(DAL.Job.COUNT, item.Count), db.CreateParameter(DAL.Job.SALARY, item.Salary), db.CreateParameter(DAL.Job.SEX, item.Sex), db.CreateParameter(DAL.Job.AGE, item.Age), db.CreateParameter(DAL.Job.DEGREE, item.Degree), db.CreateParameter(DAL.Job.EXPERIENCE, item.Experience), db.CreateParameter(DAL.Job.CONTENT, item.Content), db.CreateParameter(DAL.Job.ENDDATE, item.EndDate));
		}

		public static int Delete(int jobID)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Job.SQL_DELETE + " WHERE " + DAL.Job.JOBID + " = @" + DAL.Job.JOBID, db.CreateParameter(DAL.Job.JOBID, jobID));
		}

		#endregion
	}

    public static class Link
    {
		public const string LINKID = "LinkID";
		public const string NAME = "Name";
		public const string URL = "Url";
		public const string LOGO = "Logo";
		public const string DISPLAYORDER = "DisplayOrder";
		public const string CREATEDATE = "CreateDate";

		public const string SQL_TABLE = "ynhtm_Link";
		public const string SQL_FIELD = "LinkID,Name,Url,Logo,DisplayOrder,CreateDate";
		public const string SQL_SELECT = "SELECT LinkID,Name,Url,Logo,DisplayOrder,CreateDate FROM ynhtm_Link";
		public const string SQL_INSERT = "INSERT INTO ynhtm_Link (Name,Url,Logo,DisplayOrder) VALUES (@Name,@Url,@Logo,@DisplayOrder)";
		public const string SQL_UPDATE = "UPDATE ynhtm_Link SET Name = @Name,Url = @Url,Logo = @Logo,DisplayOrder = @DisplayOrder";
		public const string SQL_DELETE = "DELETE FROM ynhtm_Link";

        public static void FillItem(IDataReader reader, Model.ILink item)
        {
			item.LinkID = reader.GetInt32(DAL.Link.LINKID);
			item.Name = reader.GetString(DAL.Link.NAME);
			item.Url = reader.GetString(DAL.Link.URL);
			if (!reader.IsDBNull(LOGO)) item.Logo = reader.GetString(DAL.Link.LOGO);
			item.DisplayOrder = reader.GetInt32(DAL.Link.DISPLAYORDER);
			item.CreateDate = reader.GetDateTime(DAL.Link.CREATEDATE);
        }

        public static void Insert(Model.Link item)
        {
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Link.SQL_INSERT + ";" + db.IDentity, db.CreateParameter(DAL.Link.NAME, item.Name), db.CreateParameter(DAL.Link.URL, item.Url), db.CreateParameter(DAL.Link.LOGO, item.Logo), db.CreateParameter(DAL.Link.DISPLAYORDER, item.DisplayOrder)))
                {
                    if (reader.Read())
					{
						item.LinkID = Convert.ToInt32(reader.GetValue(0));
					}
                }
            }
		}

		#region LinkID

		public static Model.Link GetByLinkID(int linkID)
		{
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Link.SQL_SELECT + " WHERE " + DAL.Link.LINKID + " = @" + DAL.Link.LINKID, db.CreateParameter(DAL.Link.LINKID, linkID)))
                {
                    if (!reader.Read()) return null;
					var result = new Model.Link();
                    DAL.Link.FillItem(reader, result);
					return result;
                }
            }
		}

		public static int Update(Model.Link item)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Link.SQL_UPDATE + " WHERE " + DAL.Link.LINKID + " = @" + DAL.Link.LINKID, db.CreateParameter(DAL.Link.LINKID, item.LinkID), db.CreateParameter(DAL.Link.NAME, item.Name), db.CreateParameter(DAL.Link.URL, item.Url), db.CreateParameter(DAL.Link.LOGO, item.Logo), db.CreateParameter(DAL.Link.DISPLAYORDER, item.DisplayOrder));
		}

		public static int Delete(int linkID)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Link.SQL_DELETE + " WHERE " + DAL.Link.LINKID + " = @" + DAL.Link.LINKID, db.CreateParameter(DAL.Link.LINKID, linkID));
		}

		#endregion
	}

    public static class Post
    {
		public const string POSTID = "PostID";
		public const string CATEGORYID = "CategoryID";
		public const string USERID = "UserID";
		public const string URL = "Url";
		public const string REWRITE = "Rewrite";
		public const string THEME = "Theme";
		public const string FACE = "Face";
		public const string TITLE = "Title";
		public const string TITLESTYLE = "TitleStyle";
		public const string TITLECOLOR = "TitleColor";
		public const string SUMMARY = "Summary";
		public const string CONTENT = "Content";
		public const string SOURCE = "Source";
		public const string AUTHOR = "Author";
		public const string TAGS = "Tags";
		public const string ENABLED = "Enabled";
		public const string ISTOP = "IsTop";
		public const string ISHIDE = "IsHide";
		public const string ISPIC = "IsPic";
		public const string ISFACE = "IsFace";
		public const string VIEWCOUNT = "ViewCount";
		public const string COMMENTENABLED = "CommentEnabled";
		public const string COMMENTCOUNT = "CommentCount";
		public const string LASTDATE = "LastDate";
		public const string POSTDATE = "PostDate";

		public const string SQL_TABLE = "ynhtm_Post";
		public const string SQL_FIELD = "PostID,CategoryID,UserID,Url,Rewrite,Theme,Face,Title,TitleStyle,TitleColor,Summary,Content,Source,Author,Tags,Enabled,IsTop,IsHide,IsPic,IsFace,ViewCount,CommentEnabled,CommentCount,LastDate,PostDate";
		public const string SQL_SELECT = "SELECT PostID,CategoryID,UserID,Url,Rewrite,Theme,Face,Title,TitleStyle,TitleColor,Summary,Content,Source,Author,Tags,Enabled,IsTop,IsHide,IsPic,IsFace,ViewCount,CommentEnabled,CommentCount,LastDate,PostDate FROM ynhtm_Post";
		public const string SQL_INSERT = "INSERT INTO ynhtm_Post (CategoryID,UserID,Url,Rewrite,Theme,Face,Title,TitleStyle,TitleColor,Summary,Content,Source,Author,Tags,Enabled,IsTop,IsHide,IsPic,IsFace,ViewCount,CommentEnabled,CommentCount) VALUES (@CategoryID,@UserID,@Url,@Rewrite,@Theme,@Face,@Title,@TitleStyle,@TitleColor,@Summary,@Content,@Source,@Author,@Tags,@Enabled,@IsTop,@IsHide,@IsPic,@IsFace,@ViewCount,@CommentEnabled,@CommentCount)";
		public const string SQL_UPDATE = "UPDATE ynhtm_Post SET CategoryID = @CategoryID,Url = @Url,Rewrite = @Rewrite,Theme = @Theme,Face = @Face,Title = @Title,TitleStyle = @TitleStyle,TitleColor = @TitleColor,Summary = @Summary,Content = @Content,Source = @Source,Author = @Author,Tags = @Tags,Enabled = @Enabled,IsTop = @IsTop,IsHide = @IsHide,IsPic = @IsPic,IsFace = @IsFace,CommentEnabled = @CommentEnabled";
		public const string SQL_DELETE = "DELETE FROM ynhtm_Post";

        public static void FillItem(IDataReader reader, Model.IPost item)
        {
			item.PostID = reader.GetInt32(DAL.Post.POSTID);
			if (!reader.IsDBNull(CATEGORYID)) item.CategoryID = reader.GetInt32(DAL.Post.CATEGORYID);
			item.UserID = reader.GetInt32(DAL.Post.USERID);
			item.Url = reader.GetString(DAL.Post.URL);
			if (!reader.IsDBNull(REWRITE)) item.Rewrite = reader.GetString(DAL.Post.REWRITE);
			if (!reader.IsDBNull(THEME)) item.Theme = reader.GetString(DAL.Post.THEME);
			if (!reader.IsDBNull(FACE)) item.Face = reader.GetString(DAL.Post.FACE);
			item.Title = reader.GetString(DAL.Post.TITLE);
			item.TitleStyle = reader.GetInt32(DAL.Post.TITLESTYLE);
			if (!reader.IsDBNull(TITLECOLOR)) item.TitleColor = reader.GetString(DAL.Post.TITLECOLOR);
			if (!reader.IsDBNull(SUMMARY)) item.Summary = reader.GetString(DAL.Post.SUMMARY);
			item.Content = reader.GetString(DAL.Post.CONTENT);
			if (!reader.IsDBNull(SOURCE)) item.Source = reader.GetString(DAL.Post.SOURCE);
			if (!reader.IsDBNull(AUTHOR)) item.Author = reader.GetString(DAL.Post.AUTHOR);
			if (!reader.IsDBNull(TAGS)) item.Tags = reader.GetString(DAL.Post.TAGS);
			item.Enabled = reader.GetBoolean(DAL.Post.ENABLED);
			item.IsTop = reader.GetBoolean(DAL.Post.ISTOP);
			item.IsHide = reader.GetBoolean(DAL.Post.ISHIDE);
			item.IsPic = reader.GetBoolean(DAL.Post.ISPIC);
			item.IsFace = reader.GetBoolean(DAL.Post.ISFACE);
			item.ViewCount = reader.GetInt32(DAL.Post.VIEWCOUNT);
			item.CommentEnabled = reader.GetBoolean(DAL.Post.COMMENTENABLED);
			item.CommentCount = reader.GetInt32(DAL.Post.COMMENTCOUNT);
			item.LastDate = reader.GetDateTime(DAL.Post.LASTDATE);
			item.PostDate = reader.GetDateTime(DAL.Post.POSTDATE);
        }

        public static void Insert(Model.Post item)
        {
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Post.SQL_INSERT + ";" + db.IDentity, db.CreateParameter(DAL.Post.CATEGORYID, item.CategoryID), db.CreateParameter(DAL.Post.USERID, item.UserID), db.CreateParameter(DAL.Post.URL, item.Url), db.CreateParameter(DAL.Post.REWRITE, item.Rewrite), db.CreateParameter(DAL.Post.THEME, item.Theme), db.CreateParameter(DAL.Post.FACE, item.Face), db.CreateParameter(DAL.Post.TITLE, item.Title), db.CreateParameter(DAL.Post.TITLESTYLE, item.TitleStyle), db.CreateParameter(DAL.Post.TITLECOLOR, item.TitleColor), db.CreateParameter(DAL.Post.SUMMARY, item.Summary), db.CreateParameter(DAL.Post.CONTENT, item.Content), db.CreateParameter(DAL.Post.SOURCE, item.Source), db.CreateParameter(DAL.Post.AUTHOR, item.Author), db.CreateParameter(DAL.Post.TAGS, item.Tags), db.CreateParameter(DAL.Post.ENABLED, item.Enabled), db.CreateParameter(DAL.Post.ISTOP, item.IsTop), db.CreateParameter(DAL.Post.ISHIDE, item.IsHide), db.CreateParameter(DAL.Post.ISPIC, item.IsPic), db.CreateParameter(DAL.Post.ISFACE, item.IsFace), db.CreateParameter(DAL.Post.VIEWCOUNT, item.ViewCount), db.CreateParameter(DAL.Post.COMMENTENABLED, item.CommentEnabled), db.CreateParameter(DAL.Post.COMMENTCOUNT, item.CommentCount)))
                {
                    if (reader.Read())
					{
						item.PostID = Convert.ToInt32(reader.GetValue(0));
					}
                }
            }
		}

		#region PostID

		public static Model.Post GetByPostID(int postID)
		{
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Post.SQL_SELECT + " WHERE " + DAL.Post.POSTID + " = @" + DAL.Post.POSTID, db.CreateParameter(DAL.Post.POSTID, postID)))
                {
                    if (!reader.Read()) return null;
					var result = new Model.Post();
                    DAL.Post.FillItem(reader, result);
					return result;
                }
            }
		}

		public static int Update(Model.Post item)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Post.SQL_UPDATE + " WHERE " + DAL.Post.POSTID + " = @" + DAL.Post.POSTID, db.CreateParameter(DAL.Post.POSTID, item.PostID), db.CreateParameter(DAL.Post.CATEGORYID, item.CategoryID), db.CreateParameter(DAL.Post.URL, item.Url), db.CreateParameter(DAL.Post.REWRITE, item.Rewrite), db.CreateParameter(DAL.Post.THEME, item.Theme), db.CreateParameter(DAL.Post.FACE, item.Face), db.CreateParameter(DAL.Post.TITLE, item.Title), db.CreateParameter(DAL.Post.TITLESTYLE, item.TitleStyle), db.CreateParameter(DAL.Post.TITLECOLOR, item.TitleColor), db.CreateParameter(DAL.Post.SUMMARY, item.Summary), db.CreateParameter(DAL.Post.CONTENT, item.Content), db.CreateParameter(DAL.Post.SOURCE, item.Source), db.CreateParameter(DAL.Post.AUTHOR, item.Author), db.CreateParameter(DAL.Post.TAGS, item.Tags), db.CreateParameter(DAL.Post.ENABLED, item.Enabled), db.CreateParameter(DAL.Post.ISTOP, item.IsTop), db.CreateParameter(DAL.Post.ISHIDE, item.IsHide), db.CreateParameter(DAL.Post.ISPIC, item.IsPic), db.CreateParameter(DAL.Post.ISFACE, item.IsFace), db.CreateParameter(DAL.Post.COMMENTENABLED, item.CommentEnabled));
		}

		public static int Delete(int postID)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Post.SQL_DELETE + " WHERE " + DAL.Post.POSTID + " = @" + DAL.Post.POSTID, db.CreateParameter(DAL.Post.POSTID, postID));
		}

		#endregion
	}

    public static class Category
    {
		public const string CATEGORYID = "CategoryID";
		public const string URL = "Url";
		public const string NAME = "Name";
		public const string RSSENABLED = "RssEnabled";
		public const string MAPENABLED = "MapEnabled";
		public const string REWRITE = "Rewrite";
		public const string HOMETHEME = "HomeTheme";
		public const string LISTTHEME = "ListTheme";
		public const string POSTTHEME = "PostTheme";
		public const string POSTCOUNT = "PostCount";
		public const string COMMENTCOUNT = "CommentCount";
		public const string DISPLAYORDER = "DisplayOrder";
		public const string CREATEDATE = "CreateDate";

		public const string SQL_TABLE = "ynhtm_Category";
		public const string SQL_FIELD = "CategoryID,Url,Name,RssEnabled,MapEnabled,Rewrite,HomeTheme,ListTheme,PostTheme,PostCount,CommentCount,DisplayOrder,CreateDate";
		public const string SQL_SELECT = "SELECT CategoryID,Url,Name,RssEnabled,MapEnabled,Rewrite,HomeTheme,ListTheme,PostTheme,PostCount,CommentCount,DisplayOrder,CreateDate FROM ynhtm_Category";
		public const string SQL_INSERT = "INSERT INTO ynhtm_Category (Url,Name,RssEnabled,MapEnabled,Rewrite,HomeTheme,ListTheme,PostTheme,PostCount,CommentCount,DisplayOrder) VALUES (@Url,@Name,@RssEnabled,@MapEnabled,@Rewrite,@HomeTheme,@ListTheme,@PostTheme,@PostCount,@CommentCount,@DisplayOrder)";
		public const string SQL_UPDATE = "UPDATE ynhtm_Category SET Url = @Url,Name = @Name,RssEnabled = @RssEnabled,MapEnabled = @MapEnabled,Rewrite = @Rewrite,HomeTheme = @HomeTheme,ListTheme = @ListTheme,PostTheme = @PostTheme,DisplayOrder = @DisplayOrder";
		public const string SQL_DELETE = "DELETE FROM ynhtm_Category";

        public static void FillItem(IDataReader reader, Model.ICategory item)
        {
			item.CategoryID = reader.GetInt32(DAL.Category.CATEGORYID);
			item.Url = reader.GetString(DAL.Category.URL);
			item.Name = reader.GetString(DAL.Category.NAME);
			item.RssEnabled = reader.GetBoolean(DAL.Category.RSSENABLED);
			item.MapEnabled = reader.GetBoolean(DAL.Category.MAPENABLED);
			if (!reader.IsDBNull(REWRITE)) item.Rewrite = reader.GetString(DAL.Category.REWRITE);
			if (!reader.IsDBNull(HOMETHEME)) item.HomeTheme = reader.GetString(DAL.Category.HOMETHEME);
			if (!reader.IsDBNull(LISTTHEME)) item.ListTheme = reader.GetString(DAL.Category.LISTTHEME);
			if (!reader.IsDBNull(POSTTHEME)) item.PostTheme = reader.GetString(DAL.Category.POSTTHEME);
			item.PostCount = reader.GetInt32(DAL.Category.POSTCOUNT);
			item.CommentCount = reader.GetInt32(DAL.Category.COMMENTCOUNT);
			item.DisplayOrder = reader.GetInt32(DAL.Category.DISPLAYORDER);
			item.CreateDate = reader.GetDateTime(DAL.Category.CREATEDATE);
        }

        public static void Insert(Model.Category item)
        {
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Category.SQL_INSERT + ";" + db.IDentity, db.CreateParameter(DAL.Category.URL, item.Url), db.CreateParameter(DAL.Category.NAME, item.Name), db.CreateParameter(DAL.Category.RSSENABLED, item.RssEnabled), db.CreateParameter(DAL.Category.MAPENABLED, item.MapEnabled), db.CreateParameter(DAL.Category.REWRITE, item.Rewrite), db.CreateParameter(DAL.Category.HOMETHEME, item.HomeTheme), db.CreateParameter(DAL.Category.LISTTHEME, item.ListTheme), db.CreateParameter(DAL.Category.POSTTHEME, item.PostTheme), db.CreateParameter(DAL.Category.POSTCOUNT, item.PostCount), db.CreateParameter(DAL.Category.COMMENTCOUNT, item.CommentCount), db.CreateParameter(DAL.Category.DISPLAYORDER, item.DisplayOrder)))
                {
                    if (reader.Read())
					{
						item.CategoryID = Convert.ToInt32(reader.GetValue(0));
					}
                }
            }
		}

		#region CategoryID

		public static Model.Category GetByCategoryID(int categoryID)
		{
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Category.SQL_SELECT + " WHERE " + DAL.Category.CATEGORYID + " = @" + DAL.Category.CATEGORYID, db.CreateParameter(DAL.Category.CATEGORYID, categoryID)))
                {
                    if (!reader.Read()) return null;
					var result = new Model.Category();
                    DAL.Category.FillItem(reader, result);
					return result;
                }
            }
		}

		public static int Update(Model.Category item)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Category.SQL_UPDATE + " WHERE " + DAL.Category.CATEGORYID + " = @" + DAL.Category.CATEGORYID, db.CreateParameter(DAL.Category.CATEGORYID, item.CategoryID), db.CreateParameter(DAL.Category.URL, item.Url), db.CreateParameter(DAL.Category.NAME, item.Name), db.CreateParameter(DAL.Category.RSSENABLED, item.RssEnabled), db.CreateParameter(DAL.Category.MAPENABLED, item.MapEnabled), db.CreateParameter(DAL.Category.REWRITE, item.Rewrite), db.CreateParameter(DAL.Category.HOMETHEME, item.HomeTheme), db.CreateParameter(DAL.Category.LISTTHEME, item.ListTheme), db.CreateParameter(DAL.Category.POSTTHEME, item.PostTheme), db.CreateParameter(DAL.Category.DISPLAYORDER, item.DisplayOrder));
		}

		public static int Delete(int categoryID)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Category.SQL_DELETE + " WHERE " + DAL.Category.CATEGORYID + " = @" + DAL.Category.CATEGORYID, db.CreateParameter(DAL.Category.CATEGORYID, categoryID));
		}

		#endregion
	}

    public static class Comment
    {
		public const string COMMENTID = "CommentID";
		public const string POSTID = "PostID";
		public const string USERID = "UserID";
		public const string ISAUDIT = "IsAudit";
		public const string ISWAP = "IsWap";
		public const string NAME = "Name";
		public const string EMAIL = "Email";
		public const string CONTENT = "Content";
		public const string IPADDR = "IPAddr";
		public const string POSTDATE = "PostDate";

		public const string SQL_TABLE = "ynhtm_Comment";
		public const string SQL_FIELD = "CommentID,PostID,UserID,IsAudit,IsWap,Name,Email,Content,IPAddr,PostDate";
		public const string SQL_SELECT = "SELECT CommentID,PostID,UserID,IsAudit,IsWap,Name,Email,Content,IPAddr,PostDate FROM ynhtm_Comment";
		public const string SQL_INSERT = "INSERT INTO ynhtm_Comment (PostID,UserID,IsAudit,IsWap,Name,Email,Content,IPAddr) VALUES (@PostID,@UserID,@IsAudit,@IsWap,@Name,@Email,@Content,@IPAddr)";
		public const string SQL_UPDATE = "UPDATE ynhtm_Comment SET Content = @Content";
		public const string SQL_DELETE = "DELETE FROM ynhtm_Comment";

        public static void FillItem(IDataReader reader, Model.IComment item)
        {
			item.CommentID = reader.GetInt32(DAL.Comment.COMMENTID);
			item.PostID = reader.GetInt32(DAL.Comment.POSTID);
			if (!reader.IsDBNull(USERID)) item.UserID = reader.GetInt32(DAL.Comment.USERID);
			item.IsAudit = reader.GetBoolean(DAL.Comment.ISAUDIT);
			item.IsWap = reader.GetBoolean(DAL.Comment.ISWAP);
			if (!reader.IsDBNull(NAME)) item.Name = reader.GetString(DAL.Comment.NAME);
			if (!reader.IsDBNull(EMAIL)) item.Email = reader.GetString(DAL.Comment.EMAIL);
			item.Content = reader.GetString(DAL.Comment.CONTENT);
			item.IPAddr = reader.GetString(DAL.Comment.IPADDR);
			item.PostDate = reader.GetDateTime(DAL.Comment.POSTDATE);
        }

        public static void Insert(Model.Comment item)
        {
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Comment.SQL_INSERT + ";" + db.IDentity, db.CreateParameter(DAL.Comment.POSTID, item.PostID), db.CreateParameter(DAL.Comment.USERID, item.UserID), db.CreateParameter(DAL.Comment.ISAUDIT, item.IsAudit), db.CreateParameter(DAL.Comment.ISWAP, item.IsWap), db.CreateParameter(DAL.Comment.NAME, item.Name), db.CreateParameter(DAL.Comment.EMAIL, item.Email), db.CreateParameter(DAL.Comment.CONTENT, item.Content), db.CreateParameter(DAL.Comment.IPADDR, item.IPAddr)))
                {
                    if (reader.Read())
					{
						item.CommentID = Convert.ToInt32(reader.GetValue(0));
					}
                }
            }
		}

		#region CommentID

		public static Model.Comment GetByCommentID(int commentID)
		{
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Comment.SQL_SELECT + " WHERE " + DAL.Comment.COMMENTID + " = @" + DAL.Comment.COMMENTID, db.CreateParameter(DAL.Comment.COMMENTID, commentID)))
                {
                    if (!reader.Read()) return null;
					var result = new Model.Comment();
                    DAL.Comment.FillItem(reader, result);
					return result;
                }
            }
		}

		public static int Update(Model.Comment item)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Comment.SQL_UPDATE + " WHERE " + DAL.Comment.COMMENTID + " = @" + DAL.Comment.COMMENTID, db.CreateParameter(DAL.Comment.COMMENTID, item.CommentID), db.CreateParameter(DAL.Comment.CONTENT, item.Content));
		}

		public static int Delete(int commentID)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Comment.SQL_DELETE + " WHERE " + DAL.Comment.COMMENTID + " = @" + DAL.Comment.COMMENTID, db.CreateParameter(DAL.Comment.COMMENTID, commentID));
		}

		#endregion
	}

    public static class Setting
    {
		public const string SITENAME = "SiteName";
		public const string SITEURL = "SiteUrl";
		public const string SITEENABLED = "SiteEnabled";
		public const string METAKEYWORD = "MetaKeyWord";
		public const string METADESCR = "MetaDescr";
		public const string THEME = "Theme";
		public const string WAPTHEME = "WapTheme";
		public const string WAPENABLED = "WapEnabled";
		public const string WAPDOMAIN = "WapDomain";
		public const string AUTHCODEENABLED = "AuthcodeEnabled";
		public const string MAPENABLED = "MapEnabled";
		public const string MAPROWCOUNT = "MapRowCount";
		public const string TOTALTYPE = "TotalType";
		public const string CACHEENABLED = "CacheEnabled";
		public const string CACHEEXPIRE = "CacheExpire";
		public const string CACHETYPE = "CacheType";
		public const string OAUTHQZONEENABLED = "OAuthQzoneEnabled";
		public const string OAUTHQZONEAPPID = "OAuthQzoneAppID";
		public const string OAUTHQZONEAPPKEY = "OAuthQzoneAppKey";
		public const string USERCOUNT = "UserCount";
		public const string RSSENABLED = "RssEnabled";
		public const string RSSROWCOUNT = "RssRowCount";
		public const string RSSSHOWTYPE = "RssShowType";
		public const string PAGESIZE = "PageSize";
		public const string POSTCOUNT = "PostCount";
		public const string COMMENTENABLED = "CommentEnabled";
		public const string COMMENTSORT = "CommentSort";
		public const string COMMENTPAGESIZE = "CommentPageSize";
		public const string COMMENTAUDIT = "CommentAudit";
		public const string COMMENTDIRTY = "CommentDirty";
		public const string COMMENTCOUNT = "CommentCount";
		public const string PICMASKENABLED = "PicMaskEnabled";
		public const string PICMASKFILE = "PicMaskFile";
		public const string PICMASKPOS = "PicMaskPos";
		public const string PICQUALITY = "PicQuality";
		public const string UPFILECOUNT = "UpfileCount";
		public const string UPFILESIZE = "UpfileSize";
		public const string JOBCOUNT = "JobCount";
		public const string JOBTRYCOUNT = "JobTryCount";
		public const string CODEHEAD = "CodeHead";
		public const string CODEFOOT = "CodeFoot";
		public const string CREATEDATE = "CreateDate";

		public const string SQL_TABLE = "ynhtm_Setting";
		public const string SQL_FIELD = "SiteName,SiteUrl,SiteEnabled,MetaKeyWord,MetaDescr,Theme,WapTheme,WapEnabled,WapDomain,AuthcodeEnabled,MapEnabled,MapRowCount,TotalType,CacheEnabled,CacheExpire,CacheType,OAuthQzoneEnabled,OAuthQzoneAppID,OAuthQzoneAppKey,UserCount,RssEnabled,RssRowCount,RssShowType,PageSize,PostCount,CommentEnabled,CommentSort,CommentPageSize,CommentAudit,CommentDirty,CommentCount,PicMaskEnabled,PicMaskFile,PicMaskPos,PicQuality,UpfileCount,UpfileSize,JobCount,JobTryCount,CodeHead,CodeFoot,CreateDate";
		public const string SQL_SELECT = "SELECT SiteName,SiteUrl,SiteEnabled,MetaKeyWord,MetaDescr,Theme,WapTheme,WapEnabled,WapDomain,AuthcodeEnabled,MapEnabled,MapRowCount,TotalType,CacheEnabled,CacheExpire,CacheType,OAuthQzoneEnabled,OAuthQzoneAppID,OAuthQzoneAppKey,UserCount,RssEnabled,RssRowCount,RssShowType,PageSize,PostCount,CommentEnabled,CommentSort,CommentPageSize,CommentAudit,CommentDirty,CommentCount,PicMaskEnabled,PicMaskFile,PicMaskPos,PicQuality,UpfileCount,UpfileSize,JobCount,JobTryCount,CodeHead,CodeFoot,CreateDate FROM ynhtm_Setting";
		public const string SQL_INSERT = "INSERT INTO ynhtm_Setting (SiteName,SiteUrl,SiteEnabled,MetaKeyWord,MetaDescr,Theme,WapTheme,WapEnabled,WapDomain,AuthcodeEnabled,MapEnabled,MapRowCount,TotalType,CacheEnabled,CacheExpire,CacheType,OAuthQzoneEnabled,OAuthQzoneAppID,OAuthQzoneAppKey,UserCount,RssEnabled,RssRowCount,RssShowType,PageSize,PostCount,CommentEnabled,CommentSort,CommentPageSize,CommentAudit,CommentDirty,CommentCount,PicMaskEnabled,PicMaskFile,PicMaskPos,PicQuality,UpfileCount,UpfileSize,JobCount,JobTryCount,CodeHead,CodeFoot) VALUES (@SiteName,@SiteUrl,@SiteEnabled,@MetaKeyWord,@MetaDescr,@Theme,@WapTheme,@WapEnabled,@WapDomain,@AuthcodeEnabled,@MapEnabled,@MapRowCount,@TotalType,@CacheEnabled,@CacheExpire,@CacheType,@OAuthQzoneEnabled,@OAuthQzoneAppID,@OAuthQzoneAppKey,@UserCount,@RssEnabled,@RssRowCount,@RssShowType,@PageSize,@PostCount,@CommentEnabled,@CommentSort,@CommentPageSize,@CommentAudit,@CommentDirty,@CommentCount,@PicMaskEnabled,@PicMaskFile,@PicMaskPos,@PicQuality,@UpfileCount,@UpfileSize,@JobCount,@JobTryCount,@CodeHead,@CodeFoot)";
		public const string SQL_UPDATE = "UPDATE ynhtm_Setting SET SiteName = @SiteName,SiteUrl = @SiteUrl,SiteEnabled = @SiteEnabled,MetaKeyWord = @MetaKeyWord,MetaDescr = @MetaDescr,Theme = @Theme,WapTheme = @WapTheme,WapEnabled = @WapEnabled,WapDomain = @WapDomain,AuthcodeEnabled = @AuthcodeEnabled,MapEnabled = @MapEnabled,MapRowCount = @MapRowCount,TotalType = @TotalType,CacheEnabled = @CacheEnabled,CacheExpire = @CacheExpire,CacheType = @CacheType,OAuthQzoneEnabled = @OAuthQzoneEnabled,OAuthQzoneAppID = @OAuthQzoneAppID,OAuthQzoneAppKey = @OAuthQzoneAppKey,RssEnabled = @RssEnabled,RssRowCount = @RssRowCount,RssShowType = @RssShowType,PageSize = @PageSize,CommentEnabled = @CommentEnabled,CommentSort = @CommentSort,CommentPageSize = @CommentPageSize,CommentAudit = @CommentAudit,CommentDirty = @CommentDirty,PicMaskEnabled = @PicMaskEnabled,PicMaskFile = @PicMaskFile,PicMaskPos = @PicMaskPos,PicQuality = @PicQuality,CodeHead = @CodeHead,CodeFoot = @CodeFoot";
		public const string SQL_DELETE = "DELETE FROM ynhtm_Setting";

        public static void FillItem(IDataReader reader, Model.ISetting item)
        {
			item.SiteName = reader.GetString(DAL.Setting.SITENAME);
			item.SiteUrl = reader.GetString(DAL.Setting.SITEURL);
			item.SiteEnabled = reader.GetBoolean(DAL.Setting.SITEENABLED);
			if (!reader.IsDBNull(METAKEYWORD)) item.MetaKeyWord = reader.GetString(DAL.Setting.METAKEYWORD);
			if (!reader.IsDBNull(METADESCR)) item.MetaDescr = reader.GetString(DAL.Setting.METADESCR);
			if (!reader.IsDBNull(THEME)) item.Theme = reader.GetString(DAL.Setting.THEME);
			if (!reader.IsDBNull(WAPTHEME)) item.WapTheme = reader.GetString(DAL.Setting.WAPTHEME);
			item.WapEnabled = reader.GetBoolean(DAL.Setting.WAPENABLED);
			if (!reader.IsDBNull(WAPDOMAIN)) item.WapDomain = reader.GetString(DAL.Setting.WAPDOMAIN);
			item.AuthcodeEnabled = reader.GetBoolean(DAL.Setting.AUTHCODEENABLED);
			item.MapEnabled = reader.GetBoolean(DAL.Setting.MAPENABLED);
			item.MapRowCount = reader.GetInt32(DAL.Setting.MAPROWCOUNT);
			item.TotalType = reader.GetInt32(DAL.Setting.TOTALTYPE);
			item.CacheEnabled = reader.GetBoolean(DAL.Setting.CACHEENABLED);
			item.CacheExpire = reader.GetInt32(DAL.Setting.CACHEEXPIRE);
			item.CacheType = reader.GetInt32(DAL.Setting.CACHETYPE);
			item.OAuthQzoneEnabled = reader.GetBoolean(DAL.Setting.OAUTHQZONEENABLED);
			if (!reader.IsDBNull(OAUTHQZONEAPPID)) item.OAuthQzoneAppID = reader.GetString(DAL.Setting.OAUTHQZONEAPPID);
			if (!reader.IsDBNull(OAUTHQZONEAPPKEY)) item.OAuthQzoneAppKey = reader.GetString(DAL.Setting.OAUTHQZONEAPPKEY);
			item.UserCount = reader.GetInt32(DAL.Setting.USERCOUNT);
			item.RssEnabled = reader.GetBoolean(DAL.Setting.RSSENABLED);
			item.RssRowCount = reader.GetInt32(DAL.Setting.RSSROWCOUNT);
			item.RssShowType = reader.GetInt32(DAL.Setting.RSSSHOWTYPE);
			item.PageSize = reader.GetInt32(DAL.Setting.PAGESIZE);
			item.PostCount = reader.GetInt32(DAL.Setting.POSTCOUNT);
			item.CommentEnabled = reader.GetBoolean(DAL.Setting.COMMENTENABLED);
			item.CommentSort = reader.GetInt32(DAL.Setting.COMMENTSORT);
			item.CommentPageSize = reader.GetInt32(DAL.Setting.COMMENTPAGESIZE);
			item.CommentAudit = reader.GetInt32(DAL.Setting.COMMENTAUDIT);
			if (!reader.IsDBNull(COMMENTDIRTY)) item.CommentDirty = reader.GetString(DAL.Setting.COMMENTDIRTY);
			item.CommentCount = reader.GetInt32(DAL.Setting.COMMENTCOUNT);
			item.PicMaskEnabled = reader.GetBoolean(DAL.Setting.PICMASKENABLED);
			if (!reader.IsDBNull(PICMASKFILE)) item.PicMaskFile = reader.GetString(DAL.Setting.PICMASKFILE);
			item.PicMaskPos = reader.GetInt32(DAL.Setting.PICMASKPOS);
			item.PicQuality = reader.GetInt32(DAL.Setting.PICQUALITY);
			item.UpfileCount = reader.GetInt32(DAL.Setting.UPFILECOUNT);
			item.UpfileSize = reader.GetInt64(DAL.Setting.UPFILESIZE);
			item.JobCount = reader.GetInt32(DAL.Setting.JOBCOUNT);
			item.JobTryCount = reader.GetInt32(DAL.Setting.JOBTRYCOUNT);
			if (!reader.IsDBNull(CODEHEAD)) item.CodeHead = reader.GetString(DAL.Setting.CODEHEAD);
			if (!reader.IsDBNull(CODEFOOT)) item.CodeFoot = reader.GetString(DAL.Setting.CODEFOOT);
			item.CreateDate = reader.GetDateTime(DAL.Setting.CREATEDATE);
        }

        public static void Insert(Model.Setting item)
        {
            using (var db = DbBase.GetDb())
				db.ExecuteNonQuery(DAL.Setting.SQL_INSERT, db.CreateParameter(DAL.Setting.SITENAME, item.SiteName), db.CreateParameter(DAL.Setting.SITEURL, item.SiteUrl), db.CreateParameter(DAL.Setting.SITEENABLED, item.SiteEnabled), db.CreateParameter(DAL.Setting.METAKEYWORD, item.MetaKeyWord), db.CreateParameter(DAL.Setting.METADESCR, item.MetaDescr), db.CreateParameter(DAL.Setting.THEME, item.Theme), db.CreateParameter(DAL.Setting.WAPTHEME, item.WapTheme), db.CreateParameter(DAL.Setting.WAPENABLED, item.WapEnabled), db.CreateParameter(DAL.Setting.WAPDOMAIN, item.WapDomain), db.CreateParameter(DAL.Setting.AUTHCODEENABLED, item.AuthcodeEnabled), db.CreateParameter(DAL.Setting.MAPENABLED, item.MapEnabled), db.CreateParameter(DAL.Setting.MAPROWCOUNT, item.MapRowCount), db.CreateParameter(DAL.Setting.TOTALTYPE, item.TotalType), db.CreateParameter(DAL.Setting.CACHEENABLED, item.CacheEnabled), db.CreateParameter(DAL.Setting.CACHEEXPIRE, item.CacheExpire), db.CreateParameter(DAL.Setting.CACHETYPE, item.CacheType), db.CreateParameter(DAL.Setting.OAUTHQZONEENABLED, item.OAuthQzoneEnabled), db.CreateParameter(DAL.Setting.OAUTHQZONEAPPID, item.OAuthQzoneAppID), db.CreateParameter(DAL.Setting.OAUTHQZONEAPPKEY, item.OAuthQzoneAppKey), db.CreateParameter(DAL.Setting.USERCOUNT, item.UserCount), db.CreateParameter(DAL.Setting.RSSENABLED, item.RssEnabled), db.CreateParameter(DAL.Setting.RSSROWCOUNT, item.RssRowCount), db.CreateParameter(DAL.Setting.RSSSHOWTYPE, item.RssShowType), db.CreateParameter(DAL.Setting.PAGESIZE, item.PageSize), db.CreateParameter(DAL.Setting.POSTCOUNT, item.PostCount), db.CreateParameter(DAL.Setting.COMMENTENABLED, item.CommentEnabled), db.CreateParameter(DAL.Setting.COMMENTSORT, item.CommentSort), db.CreateParameter(DAL.Setting.COMMENTPAGESIZE, item.CommentPageSize), db.CreateParameter(DAL.Setting.COMMENTAUDIT, item.CommentAudit), db.CreateParameter(DAL.Setting.COMMENTDIRTY, item.CommentDirty), db.CreateParameter(DAL.Setting.COMMENTCOUNT, item.CommentCount), db.CreateParameter(DAL.Setting.PICMASKENABLED, item.PicMaskEnabled), db.CreateParameter(DAL.Setting.PICMASKFILE, item.PicMaskFile), db.CreateParameter(DAL.Setting.PICMASKPOS, item.PicMaskPos), db.CreateParameter(DAL.Setting.PICQUALITY, item.PicQuality), db.CreateParameter(DAL.Setting.UPFILECOUNT, item.UpfileCount), db.CreateParameter(DAL.Setting.UPFILESIZE, item.UpfileSize), db.CreateParameter(DAL.Setting.JOBCOUNT, item.JobCount), db.CreateParameter(DAL.Setting.JOBTRYCOUNT, item.JobTryCount), db.CreateParameter(DAL.Setting.CODEHEAD, item.CodeHead), db.CreateParameter(DAL.Setting.CODEFOOT, item.CodeFoot));
		}

		public static Model.Setting Get()
		{
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.Setting.SQL_SELECT))
                {
                    if (!reader.Read()) return null;
					var result = new Model.Setting();
                    DAL.Setting.FillItem(reader, result);
					return result;
                }
            }
		}

		public static int Update(Model.Setting item)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Setting.SQL_UPDATE, db.CreateParameter(DAL.Setting.SITENAME, item.SiteName), db.CreateParameter(DAL.Setting.SITEURL, item.SiteUrl), db.CreateParameter(DAL.Setting.SITEENABLED, item.SiteEnabled), db.CreateParameter(DAL.Setting.METAKEYWORD, item.MetaKeyWord), db.CreateParameter(DAL.Setting.METADESCR, item.MetaDescr), db.CreateParameter(DAL.Setting.THEME, item.Theme), db.CreateParameter(DAL.Setting.WAPTHEME, item.WapTheme), db.CreateParameter(DAL.Setting.WAPENABLED, item.WapEnabled), db.CreateParameter(DAL.Setting.WAPDOMAIN, item.WapDomain), db.CreateParameter(DAL.Setting.AUTHCODEENABLED, item.AuthcodeEnabled), db.CreateParameter(DAL.Setting.MAPENABLED, item.MapEnabled), db.CreateParameter(DAL.Setting.MAPROWCOUNT, item.MapRowCount), db.CreateParameter(DAL.Setting.TOTALTYPE, item.TotalType), db.CreateParameter(DAL.Setting.CACHEENABLED, item.CacheEnabled), db.CreateParameter(DAL.Setting.CACHEEXPIRE, item.CacheExpire), db.CreateParameter(DAL.Setting.CACHETYPE, item.CacheType), db.CreateParameter(DAL.Setting.OAUTHQZONEENABLED, item.OAuthQzoneEnabled), db.CreateParameter(DAL.Setting.OAUTHQZONEAPPID, item.OAuthQzoneAppID), db.CreateParameter(DAL.Setting.OAUTHQZONEAPPKEY, item.OAuthQzoneAppKey), db.CreateParameter(DAL.Setting.RSSENABLED, item.RssEnabled), db.CreateParameter(DAL.Setting.RSSROWCOUNT, item.RssRowCount), db.CreateParameter(DAL.Setting.RSSSHOWTYPE, item.RssShowType), db.CreateParameter(DAL.Setting.PAGESIZE, item.PageSize), db.CreateParameter(DAL.Setting.COMMENTENABLED, item.CommentEnabled), db.CreateParameter(DAL.Setting.COMMENTSORT, item.CommentSort), db.CreateParameter(DAL.Setting.COMMENTPAGESIZE, item.CommentPageSize), db.CreateParameter(DAL.Setting.COMMENTAUDIT, item.CommentAudit), db.CreateParameter(DAL.Setting.COMMENTDIRTY, item.CommentDirty), db.CreateParameter(DAL.Setting.PICMASKENABLED, item.PicMaskEnabled), db.CreateParameter(DAL.Setting.PICMASKFILE, item.PicMaskFile), db.CreateParameter(DAL.Setting.PICMASKPOS, item.PicMaskPos), db.CreateParameter(DAL.Setting.PICQUALITY, item.PicQuality), db.CreateParameter(DAL.Setting.CODEHEAD, item.CodeHead), db.CreateParameter(DAL.Setting.CODEFOOT, item.CodeFoot));
		}

		public static int Delete()
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.Setting.SQL_DELETE);
		}
	}

    public static class User
    {
		public const string USERID = "UserID";
		public const string USERNAME = "UserName";
		public const string PASSWORD = "PassWord";
		public const string OAUTHQZONEID = "OAuthQzoneID";
		public const string REALNAME = "RealName";
		public const string EMAIL = "Email";
		public const string DESCRIPTION = "Description";
		public const string ISLOCK = "IsLock";
		public const string ISADMIN = "IsAdmin";
		public const string POSTCOUNT = "PostCount";
		public const string COMMENTCOUNT = "CommentCount";
		public const string LOGINCOUNT = "LoginCount";
		public const string LASTIP = "LastIP";
		public const string LASTDATE = "LastDate";
		public const string REGIP = "RegIP";
		public const string REGDATE = "RegDate";

		public const string SQL_TABLE = "ynhtm_User";
		public const string SQL_FIELD = "UserID,UserName,PassWord,OAuthQzoneID,RealName,Email,Description,IsLock,IsAdmin,PostCount,CommentCount,LoginCount,LastIP,LastDate,RegIP,RegDate";
		public const string SQL_SELECT = "SELECT UserID,UserName,PassWord,OAuthQzoneID,RealName,Email,Description,IsLock,IsAdmin,PostCount,CommentCount,LoginCount,LastIP,LastDate,RegIP,RegDate FROM ynhtm_User";
		public const string SQL_INSERT = "INSERT INTO ynhtm_User (UserName,PassWord,OAuthQzoneID,RealName,Email,Description,IsLock,IsAdmin,PostCount,CommentCount,LoginCount,LastIP,LastDate,RegIP) VALUES (@UserName,@PassWord,@OAuthQzoneID,@RealName,@Email,@Description,@IsLock,@IsAdmin,@PostCount,@CommentCount,@LoginCount,@LastIP,@LastDate,@RegIP)";
		public const string SQL_UPDATE = "UPDATE ynhtm_User SET PassWord = @PassWord,RealName = @RealName,Email = @Email,Description = @Description,IsLock = @IsLock,IsAdmin = @IsAdmin";
		public const string SQL_DELETE = "DELETE FROM ynhtm_User";

        public static void FillItem(IDataReader reader, Model.IUser item)
        {
			item.UserID = reader.GetInt32(DAL.User.USERID);
			item.UserName = reader.GetString(DAL.User.USERNAME);
			if (!reader.IsDBNull(PASSWORD)) item.PassWord = reader.GetString(DAL.User.PASSWORD);
			if (!reader.IsDBNull(OAUTHQZONEID)) item.OAuthQzoneID = reader.GetString(DAL.User.OAUTHQZONEID);
			if (!reader.IsDBNull(REALNAME)) item.RealName = reader.GetString(DAL.User.REALNAME);
			if (!reader.IsDBNull(EMAIL)) item.Email = reader.GetString(DAL.User.EMAIL);
			if (!reader.IsDBNull(DESCRIPTION)) item.Description = reader.GetString(DAL.User.DESCRIPTION);
			item.IsLock = reader.GetBoolean(DAL.User.ISLOCK);
			item.IsAdmin = reader.GetBoolean(DAL.User.ISADMIN);
			item.PostCount = reader.GetInt32(DAL.User.POSTCOUNT);
			item.CommentCount = reader.GetInt32(DAL.User.COMMENTCOUNT);
			item.LoginCount = reader.GetInt32(DAL.User.LOGINCOUNT);
			if (!reader.IsDBNull(LASTIP)) item.LastIP = reader.GetString(DAL.User.LASTIP);
			if (!reader.IsDBNull(LASTDATE)) item.LastDate = reader.GetDateTime(DAL.User.LASTDATE);
			item.RegIP = reader.GetString(DAL.User.REGIP);
			item.RegDate = reader.GetDateTime(DAL.User.REGDATE);
        }

        public static void Insert(Model.User item)
        {
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.User.SQL_INSERT + ";" + db.IDentity, db.CreateParameter(DAL.User.USERNAME, item.UserName), db.CreateParameter(DAL.User.PASSWORD, item.PassWord), db.CreateParameter(DAL.User.OAUTHQZONEID, item.OAuthQzoneID), db.CreateParameter(DAL.User.REALNAME, item.RealName), db.CreateParameter(DAL.User.EMAIL, item.Email), db.CreateParameter(DAL.User.DESCRIPTION, item.Description), db.CreateParameter(DAL.User.ISLOCK, item.IsLock), db.CreateParameter(DAL.User.ISADMIN, item.IsAdmin), db.CreateParameter(DAL.User.POSTCOUNT, item.PostCount), db.CreateParameter(DAL.User.COMMENTCOUNT, item.CommentCount), db.CreateParameter(DAL.User.LOGINCOUNT, item.LoginCount), db.CreateParameter(DAL.User.LASTIP, item.LastIP), db.CreateParameter(DAL.User.LASTDATE, item.LastDate), db.CreateParameter(DAL.User.REGIP, item.RegIP)))
                {
                    if (reader.Read())
					{
						item.UserID = Convert.ToInt32(reader.GetValue(0));
					}
                }
            }
		}

		#region UserID

		public static Model.User GetByUserID(int userID)
		{
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.User.SQL_SELECT + " WHERE " + DAL.User.USERID + " = @" + DAL.User.USERID, db.CreateParameter(DAL.User.USERID, userID)))
                {
                    if (!reader.Read()) return null;
					var result = new Model.User();
                    DAL.User.FillItem(reader, result);
					return result;
                }
            }
		}

		public static int Update(Model.User item)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.User.SQL_UPDATE + " WHERE " + DAL.User.USERID + " = @" + DAL.User.USERID, db.CreateParameter(DAL.User.USERID, item.UserID), db.CreateParameter(DAL.User.PASSWORD, item.PassWord), db.CreateParameter(DAL.User.REALNAME, item.RealName), db.CreateParameter(DAL.User.EMAIL, item.Email), db.CreateParameter(DAL.User.DESCRIPTION, item.Description), db.CreateParameter(DAL.User.ISLOCK, item.IsLock), db.CreateParameter(DAL.User.ISADMIN, item.IsAdmin));
		}

		public static int Delete(int userID)
		{
            using (var db = DbBase.GetDb())
                return db.ExecuteNonQuery(DAL.User.SQL_DELETE + " WHERE " + DAL.User.USERID + " = @" + DAL.User.USERID, db.CreateParameter(DAL.User.USERID, userID));
		}

		#endregion

		#region UserName

		public static Model.User GetByUserName(string userName)
		{
            using (var db = DbBase.GetDb())
            {
                using (var reader = db.ExecuteReader(DAL.User.SQL_SELECT + " WHERE " + DAL.User.USERNAME + " = @" + DAL.User.USERNAME, db.CreateParameter(DAL.User.USERNAME, userName)))
                {
                    if (!reader.Read()) return null;
					var result = new Model.User();
                    DAL.User.FillItem(reader, result);
					return result;
                }
            }
		}

		#endregion
	}
}