﻿using System;
using System.Data;

namespace ynhtm.DBUtility
{
    public interface IDb : IDisposable
    {
        string IDentity { get; }
        string IsNull { get; }
        string Now { get; }

        IDbConnection Connection { get; }
        IDataParameter CreateParameter(string name, object value);
        IDbCommand CreateCommand(string commandText, params object[] parameters);
        int ExecuteNonQuery(string commandText, params object[] parameters);
        IDataReader ExecuteReader(string commandText, params object[] parameters);
        DataTable ExecuteTable(string commandText, params object[] parameters);
        object ExecuteScalar(string commandText, params object[] parameters);
        DataTable GetPage(ref int recordCount, string table, string order, int pageSize, int pageIndex = 1, IQuery query = null, string field = "*");
        DataTable GetPage(string table, string order, int pageSize, int pageIndex = 1, IQuery query = null, string field = "*");
        void Backup(string path);

        string Name { get; }
        string Size { get; }
        string Version { get; }
    }
}