﻿using System;
using System.Data;

namespace ynhtm.DBUtility
{
    public static class Reader
    {
        public static bool IsDBNull(this IDataReader reader, string name)
        {
            return reader.IsDBNull(reader.GetOrdinal(name));
        }

        public static object GetValue(this IDataReader reader, string name)
        {
            return reader.GetValue(reader.GetOrdinal(name));
        }

        public static bool GetBoolean(this IDataReader reader, string name)
        {
            return Convert.ToBoolean(reader.GetValue(name));
        }

        public static byte GetByte(this IDataReader reader, string name)
        {
            return Convert.ToByte(reader.GetOrdinal(name));
        }

        public static long GetBytes(this IDataReader reader, string name, long fieldOffset, byte[] buffer, int bufferoffset, int length)
        {
            return reader.GetBytes(reader.GetOrdinal(name), fieldOffset, buffer, bufferoffset, length);
        }

        public static char GetChar(this IDataReader reader, string name)
        {
            return Convert.ToChar(reader.GetValue(name));
        }

        public static long GetChars(this IDataReader reader, string name, long fieldOffset, char[] buffer, int bufferoffset, int length)
        {
            return reader.GetChars(reader.GetOrdinal(name), fieldOffset, buffer, bufferoffset, length);
        }

        public static DateTime GetDateTime(this IDataReader reader, string name)
        {
            return Convert.ToDateTime(reader.GetValue(name));
        }

        public static decimal GetDecimal(this IDataReader reader, string name)
        {
            return Convert.ToDecimal(reader.GetValue(name));
        }

        public static double GetDouble(this IDataReader reader, string name)
        {
            return Convert.ToDouble(reader.GetValue(name));
        }

        public static float GetFloat(this IDataReader reader, string name)
        {
            return Convert.ToSingle(reader.GetValue(name));
        }

        public static Guid GetGuid(this IDataReader reader, string name)
        {
            return reader.GetGuid(reader.GetOrdinal(name));
        }

        public static short GetInt16(this IDataReader reader, string name)
        {
            return Convert.ToInt16(reader.GetValue(name));
        }

        public static int GetInt32(this IDataReader reader, string name)
        {
            return Convert.ToInt32(reader.GetValue(name));
        }

        public static long GetInt64(this IDataReader reader, string name)
        {
            return Convert.ToInt64(reader.GetValue(name));
        }

        public static string GetString(this IDataReader reader, string name)
        {
            return Convert.ToString(reader.GetValue(name));
        }
    }
}