﻿using System;

namespace ynhtm.Model
{
    public interface IJobTry
    {
        // Properties
        int TryID { get; set; }
        int JobID { get; set; }
        string RealName { get; set; }
        int? Sex { get; set; }
        int? Wedding { get; set; }
        DateTime? Bday { get; set; }
        string School { get; set; }
        string Contact { get; set; }
        string Addr { get; set; }
        string EducationNote { get; set; }
        string WorkNote { get; set; }
        string Remark { get; set; }
        string FileUrl { get; set; }
        string IPAddr { get; set; }
        DateTime PostDate { get; set; }
    }

    /// <summary>
    /// 简历。
    /// </summary>
    [Serializable]
    public class JobTry : IJobTry
    {
        // Properties
        /// <summary>
        /// 简历编号。
        /// </summary>
        public int TryID { get; set; }
        /// <summary>
        /// 职位编号。
        /// </summary>
        public int JobID { get; set; }
        /// <summary>
        /// 姓名。
        /// </summary>
        public string RealName { get; set; }
        /// <summary>
        /// 性别。
        /// </summary>
        public int? Sex { get; set; }
        /// <summary>
        /// 婚姻状况。
        /// </summary>
        public int? Wedding { get; set; }
        /// <summary>
        /// 出生日期。
        /// </summary>
        public DateTime? Bday { get; set; }
        /// <summary>
        /// 毕业学校。
        /// </summary>
        public string School { get; set; }
        /// <summary>
        /// 联系方式。
        /// </summary>
        public string Contact { get; set; }
        /// <summary>
        /// 联系地址。
        /// </summary>
        public string Addr { get; set; }
        /// <summary>
        /// 教育经历。
        /// </summary>
        public string EducationNote { get; set; }
        /// <summary>
        /// 工作经历。
        /// </summary>
        public string WorkNote { get; set; }
        /// <summary>
        /// 备注。
        /// </summary>
        public string Remark { get; set; }
        /// <summary>
        /// 附件地址。
        /// </summary>
        public string FileUrl { get; set; }
        /// <summary>
        /// 投递 IP。
        /// </summary>
        public string IPAddr { get; set; }
        /// <summary>
        /// 投递日期。
        /// </summary>
        public DateTime PostDate { get; set; }
    }

    public interface IJob
    {
        // Properties
        int JobID { get; set; }
        int? Type { get; set; }
        string Url { get; set; }
        string Rewrite { get; set; }
        string Theme { get; set; }
        bool Enabled { get; set; }
        int ViewCount { get; set; }
        int TryCount { get; set; }
        string Name { get; set; }
        string Area { get; set; }
        int? Count { get; set; }
        decimal? Salary { get; set; }
        int? Sex { get; set; }
        int? Age { get; set; }
        int? Degree { get; set; }
        int? Experience { get; set; }
        string Content { get; set; }
        DateTime? EndDate { get; set; }
        DateTime CreateDate { get; set; }
    }

    /// <summary>
    /// 职位。
    /// </summary>
    [Serializable]
    public class Job : IJob
    {
        // Properties
        /// <summary>
        /// 职位编码。
        /// </summary>
        public int JobID { get; set; }
        /// <summary>
        /// 职位类型。
        /// </summary>
        public int? Type { get; set; }
        /// <summary>
        /// 职位地址。
        /// </summary>
        public string Url { get; set; }
        /// <summary>
        /// 重写地址。
        /// </summary>
        public string Rewrite { get; set; }
        /// <summary>
        /// 模板文件。
        /// </summary>
        public string Theme { get; set; }
        /// <summary>
        /// 状态（true 表示正常显示的职位）。
        /// </summary>
        public bool Enabled { get; set; }
        /// <summary>
        /// 查看次数。
        /// </summary>
        public int ViewCount { get; set; }
        /// <summary>
        /// 简历数量。
        /// </summary>
        public int TryCount { get; set; }
        /// <summary>
        /// 职位名称。
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 工作地区。
        /// </summary>
        public string Area { get; set; }
        /// <summary>
        /// 招聘人数（为空表示不限）。
        /// </summary>
        public int? Count { get; set; }
        /// <summary>
        /// 薪水。
        /// </summary>
        public decimal? Salary { get; set; }
        /// <summary>
        /// 性别要求（为空表示不限）。
        /// </summary>
        public int? Sex { get; set; }
        /// <summary>
        /// 年龄要求（为空表示不限）。
        /// </summary>
        public int? Age { get; set; }
        /// <summary>
        /// 学历要求（为空表示不限）。
        /// </summary>
        public int? Degree { get; set; }
        /// <summary>
        /// 工作经验（为空表示不限）。
        /// </summary>
        public int? Experience { get; set; }
        /// <summary>
        /// 描述正文。
        /// </summary>
        public string Content { get; set; }
        /// <summary>
        /// 截止日期（为空长期有效）。
        /// </summary>
        public DateTime? EndDate { get; set; }
        /// <summary>
        /// 发布日期。
        /// </summary>
        public DateTime CreateDate { get; set; }
    }

    public interface ILink
    {
        // Properties
        int LinkID { get; set; }
        string Name { get; set; }
        string Url { get; set; }
        string Logo { get; set; }
        int DisplayOrder { get; set; }
        DateTime CreateDate { get; set; }
    }

    /// <summary>
    /// 友情链接。
    /// </summary>
    [Serializable]
    public class Link : ILink
    {
        // Properties
        /// <summary>
        /// 链接编号。
        /// </summary>
        public int LinkID { get; set; }
        /// <summary>
        /// 链接名称。
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 链接地址。
        /// </summary>
        public string Url { get; set; }
        /// <summary>
        /// 图标地址。
        /// </summary>
        public string Logo { get; set; }
        /// <summary>
        /// 排序方式。
        /// </summary>
        public int DisplayOrder { get; set; }
        /// <summary>
        /// 添加日期。
        /// </summary>
        public DateTime CreateDate { get; set; }
    }

    public interface IPost
    {
        // Properties
        int PostID { get; set; }
        int? CategoryID { get; set; }
        int UserID { get; set; }
        string Url { get; set; }
        string Rewrite { get; set; }
        string Theme { get; set; }
        string Face { get; set; }
        string Title { get; set; }
        int TitleStyle { get; set; }
        string TitleColor { get; set; }
        string Summary { get; set; }
        string Content { get; set; }
        string Source { get; set; }
        string Author { get; set; }
        string Tags { get; set; }
        bool Enabled { get; set; }
        bool IsTop { get; set; }
        bool IsHide { get; set; }
        bool IsPic { get; set; }
        bool IsFace { get; set; }
        int ViewCount { get; set; }
        bool CommentEnabled { get; set; }
        int CommentCount { get; set; }
        DateTime LastDate { get; set; }
        DateTime PostDate { get; set; }
    }

    /// <summary>
    /// 文章。
    /// </summary>
    [Serializable]
    public class Post : IPost
    {
        // Properties
        /// <summary>
        /// 文章编号。
        /// </summary>
        public int PostID { get; set; }
        /// <summary>
        /// 栏目编号（不属于任何栏目为 null）。
        /// </summary>
        public int? CategoryID { get; set; }
        /// <summary>
        /// 作者编号。
        /// </summary>
        public int UserID { get; set; }
        /// <summary>
        /// 文章地址。
        /// </summary>
        public string Url { get; set; }
        /// <summary>
        /// 重写地址。
        /// </summary>
        public string Rewrite { get; set; }
        /// <summary>
        /// 模板文件。
        /// </summary>
        public string Theme { get; set; }
        /// <summary>
        /// 封面图地址。
        /// </summary>
        public string Face { get; set; }
        /// <summary>
        /// 标题。
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// 标题样式。
        /// </summary>
        public int TitleStyle { get; set; }
        /// <summary>
        /// 标题颜色。
        /// </summary>
        public string TitleColor { get; set; }
        /// <summary>
        /// 文章摘要。
        /// </summary>
        public string Summary { get; set; }
        /// <summary>
        /// 正文。
        /// </summary>
        public string Content { get; set; }
        /// <summary>
        /// 来源。
        /// </summary>
        public string Source { get; set; }
        /// <summary>
        /// 作者。
        /// </summary>
        public string Author { get; set; }
        /// <summary>
        /// 标签。
        /// </summary>
        public string Tags { get; set; }
        /// <summary>
        /// 状态（true 表示发布的）。
        /// </summary>
        public bool Enabled { get; set; }
        /// <summary>
        /// 推荐的。
        /// </summary>
        public bool IsTop { get; set; }
        /// <summary>
        /// 隐藏的。
        /// </summary>
        public bool IsHide { get; set; }
        /// <summary>
        /// 包含图片。
        /// </summary>
        public bool IsPic { get; set; }
        /// <summary>
        /// 包含封面。
        /// </summary>
        public bool IsFace { get; set; }
        /// <summary>
        /// 查看次数。
        /// </summary>
        public int ViewCount { get; set; }
        /// <summary>
        /// 开启评论。
        /// </summary>
        public bool CommentEnabled { get; set; }
        /// <summary>
        /// 评论数量。
        /// </summary>
        public int CommentCount { get; set; }
        /// <summary>
        /// 最后修改日期。
        /// </summary>
        public DateTime LastDate { get; set; }
        /// <summary>
        /// 发布日期。
        /// </summary>
        public DateTime PostDate { get; set; }
    }

    public interface ICategory
    {
        // Properties
        int CategoryID { get; set; }
        string Url { get; set; }
        string Name { get; set; }
        bool RssEnabled { get; set; }
        bool MapEnabled { get; set; }
        string Rewrite { get; set; }
        string HomeTheme { get; set; }
        string ListTheme { get; set; }
        string PostTheme { get; set; }
        int PostCount { get; set; }
        int CommentCount { get; set; }
        int DisplayOrder { get; set; }
        DateTime CreateDate { get; set; }
    }

    /// <summary>
    /// 栏目。
    /// </summary>
    [Serializable]
    public class Category : ICategory
    {
        // Properties
        /// <summary>
        /// 栏目编号。
        /// </summary>
        public int CategoryID { get; set; }
        /// <summary>
        /// 栏目地址。
        /// </summary>
        public string Url { get; set; }
        /// <summary>
        /// 栏目名称。
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// RSS 订阅。
        /// </summary>
        public bool RssEnabled { get; set; }
        /// <summary>
        /// 站点地图。
        /// </summary>
        public bool MapEnabled { get; set; }
        /// <summary>
        /// 重写地址。
        /// </summary>
        public string Rewrite { get; set; }
        /// <summary>
        /// 首页模板（没有首页为空）。
        /// </summary>
        public string HomeTheme { get; set; }
        /// <summary>
        /// 列表页模板。
        /// </summary>
        public string ListTheme { get; set; }
        /// <summary>
        /// 文章页模板。
        /// </summary>
        public string PostTheme { get; set; }
        /// <summary>
        /// 文章数量。
        /// </summary>
        public int PostCount { get; set; }
        /// <summary>
        /// 评论数量。
        /// </summary>
        public int CommentCount { get; set; }
        /// <summary>
        /// 排序。
        /// </summary>
        public int DisplayOrder { get; set; }
        /// <summary>
        /// 创建日期。
        /// </summary>
        public DateTime CreateDate { get; set; }
    }

    public interface IComment
    {
        // Properties
        int CommentID { get; set; }
        int PostID { get; set; }
        int? UserID { get; set; }
        bool IsAudit { get; set; }
        bool IsWap { get; set; }
        string Name { get; set; }
        string Email { get; set; }
        string Content { get; set; }
        string IPAddr { get; set; }
        DateTime PostDate { get; set; }
    }

    /// <summary>
    /// 评论。
    /// </summary>
    [Serializable]
    public class Comment : IComment
    {
        // Properties
        /// <summary>
        /// 评论编号。
        /// </summary>
        public int CommentID { get; set; }
        /// <summary>
        /// 文章编号。
        /// </summary>
        public int PostID { get; set; }
        /// <summary>
        /// 评论用户编号（没有为 null）。
        /// </summary>
        public int? UserID { get; set; }
        /// <summary>
        /// 审核的。
        /// </summary>
        public bool IsAudit { get; set; }
        /// <summary>
        /// WAP 评论。
        /// </summary>
        public bool IsWap { get; set; }
        /// <summary>
        /// 用户名。
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 邮件地址。
        /// </summary>
        public string Email { get; set; }
        /// <summary>
        /// 评论内容。
        /// </summary>
        public string Content { get; set; }
        /// <summary>
        /// 发布 IP。
        /// </summary>
        public string IPAddr { get; set; }
        /// <summary>
        /// 评论日期。
        /// </summary>
        public DateTime PostDate { get; set; }
    }

    public interface ISetting
    {
        // Properties
        string SiteName { get; set; }
        string SiteUrl { get; set; }
        bool SiteEnabled { get; set; }
        string MetaKeyWord { get; set; }
        string MetaDescr { get; set; }
        string Theme { get; set; }
        string WapTheme { get; set; }
        bool WapEnabled { get; set; }
        string WapDomain { get; set; }
        bool AuthcodeEnabled { get; set; }
        bool MapEnabled { get; set; }
        int MapRowCount { get; set; }
        int TotalType { get; set; }
        bool CacheEnabled { get; set; }
        int CacheExpire { get; set; }
        int CacheType { get; set; }
        bool OAuthQzoneEnabled { get; set; }
        string OAuthQzoneAppID { get; set; }
        string OAuthQzoneAppKey { get; set; }
        int UserCount { get; set; }
        bool RssEnabled { get; set; }
        int RssRowCount { get; set; }
        int RssShowType { get; set; }
        int PageSize { get; set; }
        int PostCount { get; set; }
        bool CommentEnabled { get; set; }
        int CommentSort { get; set; }
        int CommentPageSize { get; set; }
        int CommentAudit { get; set; }
        string CommentDirty { get; set; }
        int CommentCount { get; set; }
        bool PicMaskEnabled { get; set; }
        string PicMaskFile { get; set; }
        int PicMaskPos { get; set; }
        int PicQuality { get; set; }
        int UpfileCount { get; set; }
        long UpfileSize { get; set; }
        int JobCount { get; set; }
        int JobTryCount { get; set; }
        string CodeHead { get; set; }
        string CodeFoot { get; set; }
        DateTime CreateDate { get; set; }
    }

    /// <summary>
    /// 网站设置。
    /// </summary>
    [Serializable]
    public class Setting : ISetting
    {
        // Properties
        /// <summary>
        /// 网站名称。
        /// </summary>
        public string SiteName { get; set; }
        /// <summary>
        /// 网站地址。
        /// </summary>
        public string SiteUrl { get; set; }
        /// <summary>
        /// 开启网站。
        /// </summary>
        public bool SiteEnabled { get; set; }
        /// <summary>
        /// Meta Keywords。
        /// </summary>
        public string MetaKeyWord { get; set; }
        /// <summary>
        /// Meta Description。
        /// </summary>
        public string MetaDescr { get; set; }
        /// <summary>
        /// 模板目录。
        /// </summary>
        public string Theme { get; set; }
        /// <summary>
        /// WAP 模板目录。
        /// </summary>
        public string WapTheme { get; set; }
        /// <summary>
        /// 开启 WAP 网站。
        /// </summary>
        public bool WapEnabled { get; set; }
        /// <summary>
        /// WAP 网站域名。
        /// </summary>
        public string WapDomain { get; set; }
        /// <summary>
        /// 验证码。
        /// </summary>
        public bool AuthcodeEnabled { get; set; }
        /// <summary>
        /// 站点地图。
        /// </summary>
        public bool MapEnabled { get; set; }
        /// <summary>
        /// 站点地图行数。
        /// </summary>
        public int MapRowCount { get; set; }
        /// <summary>
        /// 文章统计方式。
        /// </summary>
        public int TotalType { get; set; }
        /// <summary>
        /// 缓存状态。
        /// </summary>
        public bool CacheEnabled { get; set; }
        /// <summary>
        /// 缓存时间（分钟）。
        /// </summary>
        public int CacheExpire { get; set; }
        /// <summary>
        /// 缓存类型。
        /// </summary>
        public int CacheType { get; set; }
        /// <summary>
        /// OAuth Qzone 状态。
        /// </summary>
        public bool OAuthQzoneEnabled { get; set; }
        /// <summary>
        /// OAuth Qzone APP ID。
        /// </summary>
        public string OAuthQzoneAppID { get; set; }
        /// <summary>
        /// OAuth Qzone APP Key。
        /// </summary>
        public string OAuthQzoneAppKey { get; set; }
        /// <summary>
        /// 用户数量。
        /// </summary>
        public int UserCount { get; set; }
        /// <summary>
        /// RSS 状态。
        /// </summary>
        public bool RssEnabled { get; set; }
        /// <summary>
        /// RSS 行数。
        /// </summary>
        public int RssRowCount { get; set; }
        /// <summary>
        /// RSS 输出方式。
        /// </summary>
        public int RssShowType { get; set; }
        /// <summary>
        /// 分页数量（用在栏目列表和职位列表）。
        /// </summary>
        public int PageSize { get; set; }
        /// <summary>
        /// 文章总数。
        /// </summary>
        public int PostCount { get; set; }
        /// <summary>
        /// 评论状态。
        /// </summary>
        public bool CommentEnabled { get; set; }
        /// <summary>
        /// 评论排序。
        /// </summary>
        public int CommentSort { get; set; }
        /// <summary>
        /// 评论分页数量。
        /// </summary>
        public int CommentPageSize { get; set; }
        /// <summary>
        /// 评论审核方式。
        /// </summary>
        public int CommentAudit { get; set; }
        /// <summary>
        /// 评论脏字过滤。
        /// </summary>
        public string CommentDirty { get; set; }
        /// <summary>
        /// 评论总数。
        /// </summary>
        public int CommentCount { get; set; }
        /// <summary>
        /// 图片水印状态。
        /// </summary>
        public bool PicMaskEnabled { get; set; }
        /// <summary>
        /// 水印文件。
        /// </summary>
        public string PicMaskFile { get; set; }
        /// <summary>
        /// 水印位置。
        /// </summary>
        public int PicMaskPos { get; set; }
        /// <summary>
        /// 水印图片品质。
        /// </summary>
        public int PicQuality { get; set; }
        /// <summary>
        /// 上传文件总数。
        /// </summary>
        public int UpfileCount { get; set; }
        /// <summary>
        /// 上传文件大小（合计）。
        /// </summary>
        public long UpfileSize { get; set; }
        /// <summary>
        /// 职位总数。
        /// </summary>
        public int JobCount { get; set; }
        /// <summary>
        /// 简历总数。
        /// </summary>
        public int JobTryCount { get; set; }
        /// <summary>
        /// 页头内容。
        /// </summary>
        public string CodeHead { get; set; }
        /// <summary>
        /// 页脚内容。
        /// </summary>
        public string CodeFoot { get; set; }
        /// <summary>
        /// 网站建立时间。
        /// </summary>
        public DateTime CreateDate { get; set; }
    }

    public interface IUser
    {
        // Properties
        int UserID { get; set; }
        string UserName { get; set; }
        string PassWord { get; set; }
        string OAuthQzoneID { get; set; }
        string RealName { get; set; }
        string Email { get; set; }
        string Description { get; set; }
        bool IsLock { get; set; }
        bool IsAdmin { get; set; }
        int PostCount { get; set; }
        int CommentCount { get; set; }
        int LoginCount { get; set; }
        string LastIP { get; set; }
        DateTime? LastDate { get; set; }
        string RegIP { get; set; }
        DateTime RegDate { get; set; }
    }

    /// <summary>
    /// 用户。
    /// </summary>
    [Serializable]
    public class User : IUser
    {
        // Properties
        /// <summary>
        /// 用户编号。
        /// </summary>
        public int UserID { get; set; }
        /// <summary>
        /// 用户名。
        /// </summary>
        public string UserName { get; set; }
        /// <summary>
        /// 用户密码。
        /// </summary>
        public string PassWord { get; set; }
        /// <summary>
        /// OAuth Qzone ID。
        /// </summary>
        public string OAuthQzoneID { get; set; }
        /// <summary>
        /// 真实姓名。
        /// </summary>
        public string RealName { get; set; }
        /// <summary>
        /// 邮件地址。
        /// </summary>
        public string Email { get; set; }
        /// <summary>
        /// 说明。
        /// </summary>
        public string Description { get; set; }
        /// <summary>
        /// 锁定的。
        /// </summary>
        public bool IsLock { get; set; }
        /// <summary>
        /// 管理员。
        /// </summary>
        public bool IsAdmin { get; set; }
        /// <summary>
        /// 发布文章数。
        /// </summary>
        public int PostCount { get; set; }
        /// <summary>
        /// 发布评论数。
        /// </summary>
        public int CommentCount { get; set; }
        /// <summary>
        /// 登录次数。
        /// </summary>
        public int LoginCount { get; set; }
        /// <summary>
        /// 最后登录 IP。
        /// </summary>
        public string LastIP { get; set; }
        /// <summary>
        /// 最后登录日期。
        /// </summary>
        public DateTime? LastDate { get; set; }
        /// <summary>
        /// 注册 IP。
        /// </summary>
        public string RegIP { get; set; }
        /// <summary>
        /// 注册日期。
        /// </summary>
        public DateTime RegDate { get; set; }
    }
}