﻿using System.Configuration;

namespace ynhtm.Theme.Configuration
{
    /// <summary>
    /// WEB 配置。
    /// </summary>
    public class ConfigurationSection : System.Configuration.ConfigurationSection
    {
        /// <summary>
        /// 分页实现接口。
        /// </summary>
        [ConfigurationProperty("listProviderType")]
        public string ListProviderType
        {
            get { return (string)this["listProviderType"]; }
            set { this["listProviderType"] = value; }
        }

        /// <summary>
        /// Url 映射列表。
        /// </summary>
        [ConfigurationProperty("urls")]
        public UrlElementCollection Urls
        {
            get { return (UrlElementCollection)this["urls"]; }
            set { this["urls"] = value; }
        }

        public static ConfigurationSection GetConfig(string sectionName = "ynhtm.Theme")
        {
            return ConfigurationManager.GetSection(sectionName) as ConfigurationSection;
        }
    }
}
