﻿using System.Configuration;

namespace ynhtm.Theme.Configuration
{
    /// <summary>
    /// WAP 配置。
    /// </summary>
    public class ConfigurationSectionWap : System.Configuration.ConfigurationSection
    {
        /// <summary>
        /// 内容类型。
        /// </summary>
        [ConfigurationProperty("contentType")]
        public string ContentType
        {
            get { return (string)this["contentType"]; }
            set { this["contentType"] = value; }
        }

        /// <summary>
        /// 调试状态，开启调试后将不判断系统类型，默认 false。
        /// </summary>
        [ConfigurationProperty("debug")]
        public bool Debug
        {
            get { return (bool)this["debug"]; }
            set { this["debug"] = value; }
        }

        /// <summary>
        /// Url 映射列表。
        /// </summary>
        [ConfigurationProperty("urls")]
        public UrlElementCollection Urls
        {
            get { return (UrlElementCollection)this["urls"]; }
            set { this["urls"] = value; }
        }

        public static ConfigurationSectionWap GetConfig(string sectionName = "ynhtm.Theme.Wap")
        {
            return ConfigurationManager.GetSection(sectionName) as ConfigurationSectionWap;
        }
    }
}
