﻿using System.Configuration;

namespace ynhtm.Theme.Configuration
{
    /// <summary>
    /// 配置文件 Url 映射。
    /// </summary>
    public class UrlElement : ConfigurationElement
    {
        /// <summary>
        /// 映射地址。
        /// </summary>
        [ConfigurationProperty("url", IsRequired = true, IsKey = true)]
        public string Url
        {
            get { return (string)this["url"]; }
            set { this["url"] = value; }
        }

        /// <summary>
        /// 模板文件。
        /// </summary>
        [ConfigurationProperty("file")]
        public string File
        {
            get { return (string)this["file"]; }
            set { this["file"] = value; }
        }

        /// <summary>
        /// 重写地址。
        /// </summary>
        [ConfigurationProperty("rewrite")]
        public string Rewrite
        {
            get { return (string)this["rewrite"]; }
            set { this["rewrite"] = value; }
        }

        /// <summary>
        /// 使用正则表达式，默认 false。
        /// </summary>
        [ConfigurationProperty("regex")]
        public bool Regex
        {
            get { return (bool)this["regex"]; }
            set { this["regex"] = value; }
        }
    }
}
