﻿using System;
using System.IO;
using System.Web;

namespace ynhtm.Theme
{
    public class Rewrite : IHttpModule
    {
        public void Init(HttpApplication context)
        {
            context.BeginRequest += (a, b) =>
            {
                var request = context.Request;
                if (!File.Exists(request.PhysicalPath))
                {
                    var setting = new BLL.Setting();
                    var settingItem = setting.Get();
                    if (Parser.CONFIGWAP != null && settingItem.WapEnabled && string.Equals(request.Url.Host, settingItem.WapDomain, StringComparison.OrdinalIgnoreCase))
                        new ProcessWap().Init(context);
                    else
                        new Process().Init(context);
                }
            };
        }

        public void Dispose() { }
    }
}