﻿using System.Collections.Generic;

namespace ynhtm.Theme.Template.Category
{
    using DBUtility;

    /// <summary>
    /// 栏目首页模板。
    /// </summary>
    public abstract class TemplateHome : TemplateBase<Model.Category>
    {
        /// <summary>
        /// 获取当前栏目指定数量的文章。
        /// </summary>
        /// <param name="count">文章数量（必须）。</param>
        /// <returns>返回文章集合，无论是否包含符合条件的文章都返回。</returns>
        public List<Model.Post> GetList(int count)
        {
            return new BLL.Post().GetList(count, 1, DbBase.GetQuery().Equal(DAL.Post.CATEGORYID, this.Model.CategoryID).And().Equal(DAL.Post.ENABLED, true).And().NotEqual(DAL.Post.ISHIDE, true), "ORDER BY " + DAL.Post.ISTOP + " DESC," + DAL.Post.POSTID + " DESC").ToList<Model.Post>(DAL.Post.FillItem);
        }

        /// <summary>
        /// 获取列表页地址。
        /// </summary>
        public string ListUrl
        {
            get { return Parser.LISTPROVIDER.GetPageUrl(this.Request.RawUrl, 1); }
        }
    }
}