﻿using System.Collections.Generic;

namespace ynhtm.Theme.Template.Category
{
    using Common;
    using DBUtility;

    /// <summary>
    /// 栏目列表页模板。
    /// </summary>
    public abstract class TemplateList : TemplateList<Model.Category, Model.Post>
    {
        /// <summary>
        /// 获取当前栏目指定数量的文章。
        /// </summary>
        /// <param name="recordCount">文章数量（必须）。</param>
        /// <returns>返回文章集合，无论是否包含符合条件的文章都返回。</returns>
        protected override List<Model.Post> GetList(ref int recordCount)
        {
            var post = new BLL.Post();
            return post.GetList(ref recordCount, this.PageSize, this.PageIndex, DbBase.GetQuery().Equal(DAL.Post.CATEGORYID, this.Model.CategoryID).And().Equal(DAL.Post.ENABLED, true).And().NotEqual(DAL.Post.ISHIDE, true), "ORDER BY " + DAL.Post.ISTOP + " DESC," + DAL.Post.POSTID + " DESC").ToList<Model.Post>(DAL.Post.FillItem);
        }

        /// <summary>
        /// 获取第一页地址。
        /// </summary>
        public override string FirstUrl
        {
            get
            {
                if (this.Model.HomeTheme.IsNullOrWhiteSpace()) return base.FirstUrl;
                return Parser.LISTPROVIDER.GetPageUrl(this.Request.RawUrl, 1);
            }
        }

        /// <summary>
        /// 获取上一页地址。
        /// </summary>
        public override string PrevUrl
        {
            get
            {
                if (this.Model.HomeTheme.IsNullOrWhiteSpace() || this.PageIndex > 2) return base.PrevUrl;
                return Parser.LISTPROVIDER.GetPageUrl(this.Request.RawUrl, 1);
            }
        }
    }
}
