﻿using System.Collections.Generic;

namespace ynhtm.Theme.Template.Job
{
    using DBUtility;

    /// <summary>
    /// 职位列表页模板。
    /// </summary>
    public abstract class TemplateList : TemplateList<Model.Job>
    {
        protected override List<Model.Job> GetList(ref int recordCount)
        {
            var job = new BLL.Job();
            return job.GetList(ref recordCount, this.PageSize, this.PageIndex, DbBase.GetQuery().Equal(DAL.Job.SQL_TABLE + "." + DAL.Job.ENABLED, true)).ToList<Model.Job>(DAL.Job.FillItem);
        }

        /// <summary>
        /// 获取类型。
        /// </summary>
        /// <param name="item">职位实例。</param>
        /// <returns>返回类型。</returns>
        public string GetType(Model.Job item)
        {
            return new BLL.Job().GetType(item.Type);
        }

        /// <summary>
        /// 获取性别。
        /// </summary>
        /// <param name="item">职位实例。</param>
        /// <returns>返回性别。</returns>
        public string GetSex(Model.Job item)
        {
            return new BLL.Job().GetSex(item.Sex);
        }

        /// <summary>
        /// 获取学历。
        /// </summary>
        /// <param name="item">职位实例。</param>
        /// <returns>返回学历。</returns>
        public string GetDegree(Model.Job item)
        {
            return new BLL.Job().GetDegree(item.Degree);
        }

        /// <summary>
        /// 获取工作经验。
        /// </summary>
        /// <param name="item">职位实例。</param>
        /// <returns>返回工作经验。</returns>
        public string GetExperience(Model.Job item)
        {
            return new BLL.Job().GetExperience(item.Experience);
        }
    }
}
