﻿using System;
using System.Collections.Generic;

namespace ynhtm.Theme.Template
{
    using WebControls;

    /// <summary>
    /// 列表页面模板。
    /// </summary>
    public abstract class TemplateList<TModel, TItem> : TemplateList<TItem>, ITemplate<TModel>
    {
        /// <summary>
        /// 页面数据实体。
        /// </summary>
        public TModel Model { get; set; }
    }

    /// <summary>
    /// 列表页面模板。
    /// </summary>
    public abstract class TemplateList<TItem> : TemplateBase, ITemplateList<TItem>
    {
        protected abstract List<TItem> GetList(ref int recordCount);

        /// <summary>
        /// 取得分页数据。
        /// </summary>
        /// <param name="buttonCount">要显示的按钮数量。</param>
        /// <returns>返回 PageItem 集合。</returns>
        public List<PageItem> GetPageList(int buttonCount)
        {
            PageUrlCallback callBack = delegate(int index) { return Parser.LISTPROVIDER.GetPageUrl(this.Request.RawUrl, index); };
            return Pager.GetPageList(buttonCount, this.PageIndex, this.PageCount, this.FirstUrl, callBack);
        }

        List<TItem> list;
        /// <summary>
        /// 列表数据集合。
        /// </summary>
        public List<TItem> List
        {
            get
            {
                if (this.list == null)
                {
                    var recordCount = 0;
                    this.list = this.GetList(ref recordCount);
                    this.RecordCount = recordCount;
                }
                return this.list;
            }
        }

        /// <summary>
        /// 获取第一页地址。
        /// </summary>
        public virtual string FirstUrl
        {
            get { return Parser.LISTPROVIDER.GetFirstUrl(this.Request.RawUrl); }
        }

        /// <summary>
        /// 获取最后一页地址。
        /// </summary>
        public virtual string LastUrl
        {
            get { return Parser.LISTPROVIDER.GetLastUrl(this.Request.RawUrl, this.PageCount); }
        }

        /// <summary>
        /// 获取上一页地址。
        /// </summary>
        public virtual string PrevUrl
        {
            get { return Parser.LISTPROVIDER.GetPrevUrl(this.Request.RawUrl); }
        }

        /// <summary>
        /// 获取下一页地址。
        /// </summary>
        public string NextUrl
        {
            get { return Parser.LISTPROVIDER.GetNextUrl(this.Request.RawUrl, this.PageCount); }
        }

        /// <summary>
        /// 获取总页数。
        /// </summary>
        public virtual int PageCount
        {
            get { return (int)Math.Ceiling(this.RecordCount / (double)this.PageSize); }
        }

        /// <summary>
        /// 获取当前页数。
        /// </summary>
        public virtual int PageIndex
        {
            get { return Parser.LISTPROVIDER.GetPageIndex(this.Request.RawUrl); }
        }

        int pageSize = 0;
        /// <summary>
        /// 获取或设置分页大小。
        /// </summary>
        public virtual int PageSize
        {
            get
            {
                if (this.pageSize > 0) return this.pageSize;
                var setting = new BLL.Setting();
                var settingItem = setting.Get();
                return Math.Max(settingItem.PageSize, 1);
            }
            set { this.pageSize = value; }
        }

        /// <summary>
        /// 记录总数。
        /// </summary>
        public virtual int RecordCount { get; private set; }

        public ITemplate Template
        {
            get { return this; }
        }

        public override void Clear()
        {
            this.list = null;
            base.Clear();
        }
    }
}