﻿using System.ComponentModel;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;

namespace ynhtm.Upfile
{
    using Lib;

    public partial class Item : UserControl
    {
        public Item()
        {
            InitializeComponent();
        }

        public Lib.Item Data { get; private set; }

        private void UserControl_Loaded(object sender, RoutedEventArgs e)
        {
            var data = base.DataContext as Lib.Item;
            this.Data = data;
            data.PropertyChanged += this.Data_PropertyChanged;
            this.Data_PropertyChanged(data, new PropertyChangedEventArgs(null));
            this.bordDelete.Opacity = 0.5D;
        }

        private void Data_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            var data = (Lib.Item)sender;
            this.lnkPic.IsEnabled = data.Status == ItemStatus.Done;
            this.bordText.Visibility = data.Text == null ? Visibility.Collapsed : Visibility.Visible;
            this.bordText.Background = data.Status == ItemStatus.Error ? new SolidColorBrush(Color.FromArgb(200, 255, 0, 0)) : new SolidColorBrush(Color.FromArgb(150, 0, 0, 0));
        }

        private void lnkPic_Clicking(object sender, CancelEventArgs e)
        {
            this.Data.OnClick(e);
        }

        private void lnkDelete_Click(object sender, RoutedEventArgs e)
        {
            this.Data.OnDelete();
        }

        private void bordBg_MouseEnter(object sender, MouseEventArgs e)
        {
            var bord = (Border)sender;
            bord.Background = bord.BorderBrush;
        }

        private void bordBg_MouseLeave(object sender, MouseEventArgs e)
        {
            ((Border)sender).Background = new SolidColorBrush(Colors.Transparent);
        }

        private void lnkDelete_MouseEnter(object sender, MouseEventArgs e)
        {
            this.bordDelete.Opacity = 1D;
        }

        private void lnkDelete_MouseLeave(object sender, MouseEventArgs e)
        {
            this.bordDelete.Opacity = 0.5D;
        }
    }
}
