﻿using System;
using System.IO;
using System.IO.IsolatedStorage;
using System.Net;
using System.Net.Browser;
using System.Text.RegularExpressions;
using System.Windows.Browser;

namespace ynhtm.Upfile.Lib
{
    public static class Utils
    {
        public static string ALLOWEDPATTERN;
        public const string ALLOWEDEXTS = "*.7z;*.aiff;*.asf;*.avi;*.bmp;*.csv;*.doc;*.fla;*.flv;*.gif;*.gz;*.gzip;*.jpeg;*.jpg;*.mid;*.mov;*.mp3;*.mp4;*.mpc;*.mpeg;*.mpg;*.ods;*.odt;*.pdf;*.png;*.ppt;*.pxd;*.qt;*.ram;*.rar;*.rm;*.rmi;*.rmvb;*.rtf;*.sdc;*.sitd;*.swf;*.sxc;*.sxw;*.tar;*.tgz;*.tif;*.tiff;*.txt;*.vsd;*.wav;*.wma;*.wmv;*.xls;*.xml;*.zip";

        static Utils()
        {
            ALLOWEDPATTERN = "\\.(" + ALLOWEDEXTS.Replace("*.", "").Replace(";", "|") + ")$";
        }

        public static bool IsNullOrEmpty(this string s)
        {
            return string.IsNullOrEmpty(s);
        }

        public static bool IsNullOrWhiteSpace(this string s)
        {
            return string.IsNullOrEmpty(s) || s.Trim().Length == 0;
        }

        public static string HtmlEncode(this string s)
        {
            if (s.IsNullOrEmpty()) return s;
            return HttpUtility.HtmlEncode(s);
        }

        public static string HtmlDecode(this string s)
        {
            if (s.IsNullOrEmpty()) return s;
            return HttpUtility.HtmlDecode(s);
        }

        public static string UrlEncode(this string s)
        {
            if (s.IsNullOrEmpty()) return s;
            return HttpUtility.UrlEncode(s);
        }

        public static string UrlDecode(this string s)
        {
            if (s.IsNullOrEmpty()) return s;
            return HttpUtility.UrlDecode(s);
        }

        public static object TryInvoke(this HtmlWindow window, string name, params object[] args)
        {
            var script = window.GetProperty(name) as ScriptObject;
            if (script == null) return null;
            return script.InvokeSelf(args);
        }

        public static bool IsPic(string ext)
        {
            return Regex.IsMatch(ext, @"\.(jpg|jpeg|bmp|png)$", RegexOptions.IgnoreCase);
        }

        public static T GetValue<T>(this IsolatedStorageSettings settings, string key, T defaultValue = default(T))
        {
            if (!settings.Contains(key)) return defaultValue;
            var obj = settings[key];
            if (obj is T) return defaultValue;
            return (T)obj;
        }

        public static void Save(this IsolatedStorageSettings settings, string key, object value)
        {
            settings[key] = value;
            settings.Save();
        }

        public static string GetFileSize(long length)
        {
            if (1073741824 <= length) return (length / 1073741824F).ToString("0.##") + " GB";
            if (1048576 <= length) return (length / 1048576F).ToString("0.##") + " MB";
            if (1024 <= length) return (length / 1024F).ToString("0.##") + " KB";
            return length + " 字节";
        }

        public static void GetHttp(Uri url, Action<string> completed = null)
        {
            var request = (HttpWebRequest)WebRequestCreator.BrowserHttp.Create(url);
            request.Method = "GET";
            request.BeginGetResponse((IAsyncResult ar) =>
            {
                var response = (HttpWebResponse)request.EndGetResponse(ar);
                if (completed != null) using (var reader = new StreamReader(response.GetResponseStream())) completed(reader.ReadToEnd());
            }, null);

        }
    }
}
