﻿using System;
using System.Web;

namespace ynhtm.API
{
    using Common;
    using DBUtility;

    public class Rss : BaseHandler
    {
        public override void Process()
        {
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            if (settingItem.RssEnabled)
            {
                var request = this.Request;
                var response = this.Response;
                response.Clear();
                response.Cache.SetCacheability(HttpCacheability.NoCache);
                response.Cache.SetNoStore();
                var xml = this.OutputXml;
                xml.WriteStartDocument();
                xml.WriteStartElement("rss");
                xml.WriteAttributeString("version", "2.0");

                xml.WriteStartElement("channel");
                xml.WriteElementString("title", settingItem.SiteName);
                xml.WriteElementString("link", settingItem.SiteUrl.IifNullOrWhiteSpace(new Uri(request.Url, "/").ToString()));
                xml.WriteStartElement("description");
                xml.WriteCData(settingItem.MetaDescr);
                xml.WriteEndElement();
                var post = new BLL.Post();
                foreach (var i in post.GetList(Math.Max(settingItem.RssRowCount, 1), query: DbBase.GetQuery().Equal(DAL.Post.ENABLED, true).And().NotEqual(DAL.Post.ISHIDE, true).And().NotEqual(DAL.Post.ISHIDE, true).And().NotIn(DAL.Post.CATEGORYID, new QueryText("SELECT " + DAL.Category.CATEGORYID + " FROM " + DAL.Category.SQL_TABLE + " WHERE " + DAL.Category.RSSENABLED + " = 0"))).ToList<Model.Post>(DAL.Post.FillItem))
                {
                    xml.WriteStartElement("item");
                    xml.WriteElementString("title", i.Title);
                    if (settingItem.RssShowType != 1)
                    {
                        xml.WriteStartElement("description");
                        switch (settingItem.RssShowType)
                        {
                            case 2:
                                xml.WriteCData(i.Summary);
                                break;
                            case 3:
                                xml.WriteCData(i.Content.HtmlDel().Substr(200, "...").HtmlWrap());
                                break;
                            case 4:
                                xml.WriteCData(i.Content);
                                break;
                        }
                        xml.WriteEndElement();
                    }
                    xml.WriteElementString("link", new Uri(request.Url, i.Url).ToString());
                    xml.WriteElementString("author", i.Author);
                    xml.WriteElementString("pubDate", i.PostDate.ToString("yyy-MM-ddTHH:mm:sszzz"));
                    xml.WriteEndElement();
                }
                xml.WriteEndElement();
                xml.WriteEndElement();
                xml.WriteEndDocument();
                xml.Close();
                response.End();
            }
        }
    }
}