﻿using System;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;
using System.Web.UI.WebControls;

namespace ynhtm.Admin
{
    using Common;

    public partial class CategoryList : System.Web.UI.Page
    {
        void ControlBind()
        {
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            var dir = new DirectoryInfo(this.MapPath("~/Theme/" + settingItem.Theme.IifNullOrWhiteSpace("Default")));
            if (!dir.Exists) return;
            var files = dir.GetFiles();
            foreach (var i in files.Where(i => Regex.IsMatch(i.Extension, @"\.(cshtml|vbhtml)$", RegexOptions.Compiled | RegexOptions.IgnoreCase)))
            {
                this.dropHomeTheme.Items.Add(i.Name);
                if (i.Name.StartsWith("List", StringComparison.OrdinalIgnoreCase)) this.dropListTheme.Items.Add(i.Name);
                if (i.Name.StartsWith("Post", StringComparison.OrdinalIgnoreCase)) this.dropPostTheme.Items.Add(i.Name);
            }
        }

        void ControlReset()
        {
            this.txtName.Text = "";
            this.txtRewrite.Text = "";
        }

        void SetValue(Model.Category item)
        {
            item.Name = this.txtName.Text;
            item.RssEnabled = this.chkRssEnabled.Checked;
            item.MapEnabled = this.chkMapEnabled.Checked;
            item.Rewrite = this.txtRewrite.Text;
            item.HomeTheme = this.dropHomeTheme.Text;
            item.ListTheme = this.dropListTheme.Text;
            item.PostTheme = this.dropPostTheme.Text;
            item.DisplayOrder = this.txtDisplayOrder.Get(int.Parse);
        }

        void AddBegin()
        {
            this.ViewState["KeyID"] = null;
            this.lblSubTitle.Text = "添加栏目";
            this.btnEdit.Text = "添加";
            this.btnCancel.Visible = false;
        }

        void AddEnd()
        {
            var item = new Model.Category();
            this.SetValue(item);
            var category = new BLL.Category();
            category.Insert(item);
        }

        void EditBegin(int keyID)
        {
            this.ViewState["KeyID"] = keyID;
            this.lblSubTitle.Text = "编辑栏目";
            this.btnEdit.Text = "编辑";
            this.btnCancel.Visible = true;

            var category = new BLL.Category();
            var item = category.GetByCategoryID(keyID);

            this.txtName.Text = item.Name;
            this.chkRssEnabled.Checked = item.RssEnabled;
            this.chkMapEnabled.Checked = item.MapEnabled;
            this.txtRewrite.Text = item.Rewrite;
            this.dropHomeTheme.SelectValue(item.HomeTheme);
            this.dropListTheme.SelectValue(item.ListTheme);
            this.dropPostTheme.SelectValue(item.PostTheme);
            this.txtDisplayOrder.Text = item.DisplayOrder.ToString();
        }

        void EditEnd()
        {
            var category = new BLL.Category();
            var item = category.GetByCategoryID(Convert.ToInt32(this.ViewState["KeyID"]));
            this.SetValue(item);
            category.Update(item);
        }

        void PageBind()
        {
            var category = new BLL.Category();
            this.rptList.DataSource = category.GetList();
            this.rptList.DataBind();
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.IsPostBack)
            {
                this.ControlBind();
                this.PageBind();
                this.AddBegin();
            }
        }

        protected void btnEdit_Click(object sender, EventArgs e)
        {
            if (this.IsValid)
            {
                if (this.ViewState["KeyID"] == null)
                {
                    this.AddEnd();
                    this.ControlReset();
                    this.PageBind();
                    this.ShowInfo("添加栏目成功");
                }
                else
                {
                    this.EditEnd();
                    this.PageBind();
                    this.ShowInfo("编辑栏目成功");
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            this.AddBegin();
            this.ControlReset();
            this.PageBind();
        }

        protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            if (e.CommandName == "Edit")
            {
                this.EditBegin(Convert.ToInt32(e.CommandArgument));
            }
            else if (e.CommandName == "Del")
            {
                var category = new BLL.Category();
                category.Delete(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("删除栏目成功");
            }
        }

        protected void btnUpdateList_Click(object sender, EventArgs e)
        {
            var category = new BLL.Category();
            foreach (RepeaterItem i in this.rptList.Items)
            {
                var id = i.FindControl("hidSelectID") as HiddenField;
                if (id != null) category.UpdateList(int.Parse(id.Value), ((TextBox)i.FindControl("txtName")).Text, int.Parse(((TextBox)i.FindControl("txtDisplayOrder")).Text));
            }
            this.PageBind();
            this.ShowInfo("更新列表成功");
        }
    }
}