﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Reflection;
using System.Web;

namespace ynhtm.Admin
{
    using Common;
    using DBUtility;

    public partial class Default : System.Web.UI.Page
    {
        void PageBind()
        {
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            this.lblPostCount.Text = settingItem.PostCount.ToString();
            this.lblCommentCount.Text = settingItem.CommentCount.ToString();
            this.lblUserCount.Text = settingItem.UserCount.ToString();
            this.lblUpfile.Text = Utils.GetFileSize(settingItem.UpfileSize) + " (" + settingItem.UpfileCount + " 个文件)";
            this.lblCreateDate.Text = settingItem.CreateDate.ToString("f") + " (至今 " + DateTime.Now.Subtract(settingItem.CreateDate).TotalDays.ToString("0.#") + " 天)";
            this.lblWebDir.Text = this.Request.PhysicalApplicationPath;
#if !DEMO
            this.lblVersion.Text = Assembly.GetExecutingAssembly().GetName().Version.ToString();
#else
            this.lblVersion.Text = Assembly.GetExecutingAssembly().GetName().Version.ToString() + " (演示版)";
#endif

            this.lblServerName.Text = Environment.MachineName.HtmlEncode();
            this.lblCPU.Text = Environment.GetEnvironmentVariable("PROCESSOR_IDENTIFIER").HtmlEncode() + " (" + Environment.ProcessorCount + "核)";
            this.lblOS.Text = Environment.OSVersion.ToString();
            this.lblNet.Text = Environment.Version.ToString();
            this.lblServer.Text = this.Request.ServerVariables["SERVER_SOFTWARE"].HtmlEncode().IifNullOrEmpty("-");
            this.lblServerIP.Text = this.Request.ServerVariables["LOCAl_ADDR"].HtmlEncode();

            using (var db = DbBase.GetDb())
            {
                this.lblDatabase.Text = db.Name.HtmlEncode() + " (" + db.Size + ")";
                this.lblSQLServer.Text = db.Version;
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.IsPostBack)
            {
                this.PageBind();
            }
        }

        protected void btnClearCache_Click(object sender, EventArgs e)
        {
            var list = new List<string>();
            foreach (DictionaryEntry i in HttpRuntime.Cache)
            {
                list.Add(i.Key.ToString());
            }
            foreach (var i in list)
            {
                HttpRuntime.Cache.Remove(i);
            }
            this.PageBind();
            this.ShowInfo("清除缓存数据成功");
        }

        protected void btnSettingSumup_Click(object sender, EventArgs e)
        {
            var setting = new BLL.Setting();
            setting.Sumup();
            this.PageBind();
            this.ShowInfo("重新统计系统数据成功");
        }

        protected void btnCategorySumup_Click(object sender, EventArgs e)
        {
            var category = new BLL.Category();
            category.Sumup();
            this.ShowInfo("重新统计栏目数据成功");
        }

        protected void btnPostSumup_Click(object sender, EventArgs e)
        {
            var post = new BLL.Post();
            post.Sumup();
            this.ShowInfo("重新统计帖子数据成功");
        }

        protected void btnUserSumup_Click(object sender, EventArgs e)
        {
            var user = new BLL.User();
            user.Sumup();
            this.ShowInfo("重新统计用户数据成功");
        }

        protected void btnJobSumup_Click(object sender, EventArgs e)
        {
            var job = new BLL.Job();
            job.Sumup();
            this.ShowInfo("重新统计招聘数据成功");
        }

        protected void btnUpfileSumup_Click(object sender, EventArgs e)
        {
            var setting = new BLL.Setting();
            setting.SumupUpfile();
            this.PageBind();
            this.ShowInfo("重新统计附件数据成功");
        }
    }
}