﻿<%@ Page Title="应聘管理 - 管理中心" Language="C#" MasterPageFile="Frame.master" AutoEventWireup="true"
    CodeBehind="JobTryList.aspx.cs" Inherits="ynhtm.Admin.JobTryList" %>

<%@ Register Assembly="ynhtm.WebControls" Namespace="ynhtm.WebControls" TagPrefix="YNHTM" %>
<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        应聘管理</h1>
</asp:Content>
<asp:Content ID="contentRight" ContentPlaceHolderID="contentRightPlaceHolder" runat="server">
    <h2>
        搜索</h2>
    <asp:Panel runat="server" DefaultButton="btnSearch" CssClass="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtRealName">姓名:</asp:Label><br />
                    <asp:TextBox ID="txtRealName" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtJobName">职位:</asp:Label><br />
                    <asp:TextBox ID="txtJobName" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtContact">联系方式:</asp:Label><br />
                    <asp:TextBox ID="txtContact" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" CausesValidation="false"
                        UseSubmitBehavior="false" Text="搜索" />
                </td>
            </tr>
        </table>
    </asp:Panel>
</asp:Content>
<asp:Content ID="contentLeft" ContentPlaceHolderID="contentLeftPlaceHolder" runat="server">
    <table class="list" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th>
                    姓名
                </th>
                <th style="width: 150px;" class="center">
                    职位
                </th>
                <th style="width: 50px;" class="center">
                    性别
                </th>
                <th style="width: 50px;" class="center">
                    年龄
                </th>
                <th style="width: 120px;" class="center">
                    联系方式
                </th>
                <th style="width: 80px;" class="center">
                    投递日期
                </th>
                <th style="width: 50px;" class="center">
                    操作
                </th>
            </tr>
        </thead>
        <tbody>
            <YNHTM:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
                <EmptyTemplate>
                    <tr class="list-empty">
                        <td colspan="7">
                            没有任何应聘
                        </td>
                    </tr>
                </EmptyTemplate>
                <ItemTemplate>
                    <tr>
                        <td>
                            <a href="<%#this.Eval("TryID", "JobTryView.aspx?TryID={0}")%>">
                                <%#this.EvalRealName%></a>
                        </td>
                        <td class="center">
                            <a href="<%#this.Eval("JobUrl")%>" target="_blank">
                                <%#this.EvalJobName%></a>
                        </td>
                        <td class="center">
                            <%#new ynhtm.BLL.Job().GetSex(this.Eval<int?>("Sex")).IifNullOrWhiteSpace("-")%>
                        </td>
                        <td class="center">
                            <%#this.EvalAge%>
                        </td>
                        <td class="center">
                            <%#this.EvalContact%>
                        </td>
                        <td class="center">
                            <%#this.Eval("PostDate", "{0:yyy-MM-dd}")%>
                        </td>
                        <td class="center">
                            <asp:LinkButton runat="server" CausesValidation="false" CommandName="Del" CommandArgument='<%#this.Eval("TryID")%>'
                                OnClientClick="javascript:if(!confirm('确认删除该应聘吗？')) return false;">删除</asp:LinkButton>
                        </td>
                    </tr>
                </ItemTemplate>
            </YNHTM:Repeater>
        </tbody>
    </table>
    <div class="command">
        <YNHTM:Pager ID="pager" runat="server" OnPageIndexChanged="pager_PageIndexChanged">
        </YNHTM:Pager>
    </div>
</asp:Content>
