﻿using System;
using System.IO;

namespace ynhtm.Admin
{
    using Common;

    public partial class JobTryView : System.Web.UI.Page
    {
        void PageBind()
        {
            var job = new BLL.Job();
            var jobTry = new BLL.JobTry();
            var item = jobTry.GetByTryID(int.Parse(this.Request["TryID"]));
            this.lblRealName.Text = item.RealName.HtmlEncode();
            this.lblSex.Text = job.GetSex(item.Sex).IifNullOrWhiteSpace("-");
            this.lblWedding.Text = jobTry.GetWedding(item.Wedding).IifNullOrWhiteSpace("-");
            this.lblBday.Text = item.Bday == null ? "-" : item.Bday.Value.ToString("D") + " (" + (DateTime.Now.Year - item.Bday.Value.Year) + "岁)";
            this.lblSchool.Text = item.School.HtmlEncode().IifNullOrWhiteSpace("-");
            this.lblContact.Text = item.Contact.HtmlEncode().IifNullOrWhiteSpace("-");
            this.lblAddr.Text = item.Addr.HtmlEncode().IifNullOrWhiteSpace("-");
            this.lblFileUrl.Text = "-";
            if (item.FileUrl.IsNullOrWhiteSpace())
                this.lnkFileUrl.Visible = false;
            else
            {
                this.lblFileUrl.Text = Path.GetFileName(item.FileUrl).HtmlEncode();
                this.lnkFileUrl.NavigateUrl = item.FileUrl;
                this.lnkFileUrl.Visible = true;
            }
            this.lblIPAddr.Text = item.IPAddr.HtmlEncode();
            this.lnkIPAddr.NavigateUrl = "http://ip138.com/ips.asp?ip=" + item.IPAddr;
            this.lblPostDate.Text = item.PostDate.ToString("f");

            this.txtEducationNote.Text = item.EducationNote.IifNullOrWhiteSpace("(无)");
            this.txtWorkNote.Text = item.WorkNote.IifNullOrWhiteSpace("(无)");
            this.txtRemark.Text = item.Remark.IifNullOrWhiteSpace("(无)");
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.IsPostBack)
            {
                this.PageBind();
            }
        }
    }
}