﻿using System;
using System.Web.UI.WebControls;

namespace ynhtm.Admin
{
    using Common;

    public partial class LinkList : Upfile
    {
        void ControlReset()
        {
            this.txtName.Text = "";
        }

        void SetValue(Model.Link item)
        {
            item.Name = this.txtName.Text;
            item.Url = this.txtUrl.Text;
            item.Logo = this.txtLogo.Text;
            item.DisplayOrder = this.txtDisplayOrder.Get(int.Parse);
        }

        void AddBegin()
        {
            this.ViewState["KeyID"] = null;
            this.lblSubTitle.Text = "添加连接";
            this.btnEdit.Text = "添加";
            this.btnCancel.Visible = false;
        }

        void AddEnd()
        {
            var item = new Model.Link();
            this.SetValue(item);
            var category = new BLL.Link();
            category.Insert(item);
        }

        void EditBegin(int keyID)
        {
            this.ViewState["KeyID"] = keyID;
            this.lblSubTitle.Text = "编辑连接";
            this.btnEdit.Text = "编辑";
            this.btnCancel.Visible = true;

            var category = new BLL.Link();
            var item = category.GetByLinkID(keyID);

            this.txtName.Text = item.Name;
            this.txtUrl.Text = item.Url;
            this.txtLogo.Text = item.Logo;
            this.txtDisplayOrder.Text = item.DisplayOrder.ToString();
        }

        void EditEnd()
        {
            var link = new BLL.Link();
            var item = link.GetByLinkID(Convert.ToInt32(this.ViewState["KeyID"]));
            this.SetValue(item);
            link.Update(item);
        }

        void PageBind()
        {
            var link = new BLL.Link();
            this.rptList.DataSource = link.GetList();
            this.rptList.DataBind();
        }

        protected string EvalLogo
        {
            get
            {
                var logo = this.Eval<string>("Logo");
                if (logo.IsNullOrWhiteSpace()) return "(无)";
                return "<img src=\""+logo.AttributeEncode()+"\" align=\"absmiddle\" alt=\"\" />";
            }
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            this.Form.DefaultButton = this.btnEdit.UniqueID;
            if (!this.IsPostBack)
            {
                this.PageBind();
                this.AddBegin();
            }
            base.Page_Load(sender, e);
        }

        protected void btnEdit_Click(object sender, EventArgs e)
        {
            if (this.IsValid)
            {
                if (this.ViewState["KeyID"] == null)
                {
                    this.AddEnd();
                    this.ControlReset();
                    this.PageBind();
                    this.ShowInfo("添加连接成功");
                }
                else
                {
                    this.EditEnd();
                    this.PageBind();
                    this.ShowInfo("编辑连接成功");
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            this.AddBegin();
            this.ControlReset();
            this.PageBind();
        }

        protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            if (e.CommandName == "Edit")
            {
                this.EditBegin(Convert.ToInt32(e.CommandArgument));
            }
            else if (e.CommandName == "Del")
            {
                var link = new BLL.Link();
                link.Delete(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("删除连接成功");
            }
        }
    }
}