﻿using System;

namespace ynhtm.Admin
{
    using Common;

    public partial class Page : System.Web.UI.MasterPage
    {
        protected override void OnInit(EventArgs e)
        {
            var user = this.Page.User;
            var id = user.Identity;
            if (!id.IsAuthenticated || id.AuthenticationType != "Forms") this.Response.Redirect(this.ResolveUrl("Login.aspx?ErrorCode=1"));
            if (!user.IsInRole("Admin")) this.Response.Redirect(this.ResolveUrl("Login.aspx?ErrorCode=2"));
            if (((Model.IPrincipal)user).User.IsLock) this.Response.Redirect(this.ResolveUrl("Login.aspx?ErrorCode=3"));
            base.OnInit(e);
        }

        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected override void OnPreRender(EventArgs e)
        {
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            this.lnkLogo.Text = settingItem.SiteName.HtmlEncode() + "管理中心";
            var user = ((Model.IPrincipal)this.Page.User).User;
            this.lblUserName.Text = user.RealName.HtmlEncode() + "(" + user.UserName + ")";
            base.OnPreRender(e);
        }
    }
}