﻿<%@ Page Language="C#" MasterPageFile="Frame.master" AutoEventWireup="true" CodeBehind="PostEdit.aspx.cs"
    Inherits="ynhtm.Admin.PostEdit" %>

<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        <asp:Label ID="lblTitle" runat="server"></asp:Label></h1>
    <script type="text/javascript">
        function GetSummary(length) {
            var s = FCKeditorAPI.GetInstance(Page.ContentID).GetXHTML(true);
            s = s.htmlDecode();
            //截取字符
            if (typeof (length) == "number" && length > 0 && s.length > length) {
                sub = true;
                s = s.substr(0, length) + "...";
            }
            FCKeditorAPI.GetInstance(Page.SummaryID).SetHTML(s);
        }

        function Upfile_Click(url, id) {
            if (id == "Content") {
                var editor = FCKeditorAPI.GetInstance(Page.ContentID);
                if (url.match(/\.(jpg|jpeg|bmp|png|gif)$/i) != null) {
                    var img = editor.InsertElement("img");
                    img.src = url;
                } else {
                    var a = editor.InsertElement("a");
                    var n = "textContent";
                    if("innerText" in a) n = "innerText";
                    a[n] = url.match(/[^/]+$/)[0];
                    a.href = url;
                    a.target = "_blank";
                }
            } else if (id == "Face") {
                $("[id$='txtFace']").val(url);
            }
            setTimeout($.fancybox.close, 10);
        }
    </script>
</asp:Content>
<asp:Content ID="contentRight" ContentPlaceHolderID="contentRightPlaceHolder" runat="server">
    <h2>
        选项</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:CheckBox ID="chkEnabled" runat="server" Text="发表" Checked="True" />
                    <asp:CheckBox ID="chkCommentEnabled" runat="server" Text="允许评论" Checked="True" />
                    <asp:CheckBox ID="chkIsTop" runat="server" Text="推荐" />
                    <asp:CheckBox ID="chkIsHide" runat="server" Text="隐藏" ToolTip="勾选后不会在列表中显示" />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtFace">封面图片:</asp:Label>
                    <a href="Upfile.htm" onclick="javascript:$.fancybox(this.href + '?ID=Face,' + upfilePar, { width: '75%', height: '90%', transitionIn: 'none', transitionOut: 'none', type: 'iframe' });return false;">
                        选择</a><br />
                    <asp:TextBox ID="txtFace" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtSource">来源:</asp:Label><br />
                    <asp:TextBox ID="txtSource" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtAuthor">作者:</asp:Label><br />
                    <asp:TextBox ID="txtAuthor" runat="server" Width="150px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtRewrite">重写地址:</asp:Label><br />
                    <asp:TextBox ID="txtRewrite" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="dropTheme">模板文件:</asp:Label><br />
                    <asp:DropDownList ID="dropTheme" runat="server" Width="250px">
                        <asp:ListItem Value="">(默认)</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="dropCategoryID">栏目:</asp:Label><br />
                    <asp:DropDownList ID="dropCategoryID" runat="server" AppendDataBoundItems="true"
                        Width="250px">
                        <asp:ListItem Value="">(无栏目)</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Button ID="btnEdit" runat="server" OnClick="btnEdit_Click" Font-Bold="true" />
                </td>
            </tr>
        </table>
    </div>
</asp:Content>
<asp:Content ID="contentLeft" ContentPlaceHolderID="contentLeftPlaceHolder" runat="server">
    <h2>
        文章内容</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtTitle">标题:</asp:Label><br />
                    <asp:TextBox ID="txtTitle" runat="server" Width="80%"></asp:TextBox>
                    <a href="" onclick="$.Popup.show({anchor:this,content:&quot;[id$='pnlTitleStyle']&quot;});return false;">
                        样式</a>
                    <asp:RequiredFieldValidator runat="server" ControlToValidate="txtTitle" ErrorMessage="标题不能为空"></asp:RequiredFieldValidator><br />
                    <asp:Panel ID="pnlTitleStyle" runat="server" CssClass="hide popup">
                        <asp:CheckBoxList ID="chklTitleStyle" runat="server" RepeatDirection="Horizontal"
                            RepeatLayout="Flow">
                            <asp:ListItem Value="1">粗体</asp:ListItem>
                            <asp:ListItem Value="2">斜体</asp:ListItem>
                            <asp:ListItem Value="4">下划线</asp:ListItem>
                            <asp:ListItem Value="8">删除线</asp:ListItem>
                        </asp:CheckBoxList>
                        <div class="colors clearfix">
                        </div>
                        <asp:TextBox ID="txtTitleColor" runat="server" Width="80px"></asp:TextBox>
                        <input type="button" value="确定" class="btn" onclick="$(&quot;[id$='pnlTitleStyle']&quot;).hide();" />
                        <script type="text/javascript">
                            $.TitleStyle = {
                                titleExp: "[id$='txtTitle']",
                                styleExp: "[id$='chklTitleStyle'] :checkbox",
                                colorExp: "[id$='txtTitleColor']",
                                colorTableExp: ".colors",
                                init: function () {
                                    var arr = ['00', '33', '66', '99', 'CC', 'FF'];
                                    for (var i = 0; i < 6; i++) {
                                        for (var j = 0; j < 6; j++) {
                                            for (var k = 0; k < 6; k++) {
                                                var c = "#" + arr[i] + arr[j] + arr[k];
                                                $($.TitleStyle.colorTableExp).append($("<a/>").attr({ href: "", title: c }).css("background", c).click(function () {
                                                    var c = this.title;
                                                    var h = c.charAt(0) == "#" ? c.substring(1, 7) : c;
                                                    var r = 255 - parseInt(h.substring(0, 2), 16);
                                                    var g = 255 - parseInt(h.substring(2, 4), 16);
                                                    var b = 255 - parseInt(h.substring(4, 6), 16);
                                                    $($.TitleStyle.colorExp).val(c).css({ background: c, color: "#" + (b | (g << 8) | (r << 16)).toString(16) });
                                                    $.TitleStyle.update();
                                                    return false;
                                                }));
                                            }
                                        }
                                    }
                                    $(this.styleExp).click(function () { $.TitleStyle.update(); });
                                    $(this.colorExp).change(function () { $.TitleStyle.update(); });
                                    this.update();
                                },
                                update: function () {
                                    $(this.titleExp).css(this.getCss());
                                },
                                getCss: function () {
                                    var css = {};
                                    css.fontWeight = $(this.styleExp + "[value='1']").is(":checked") ? "bold" : "normal";
                                    css.fontStyle = $(this.styleExp + "[value='2']").is(":checked") ? "italic" : "normal";
                                    var s = "";
                                    s += $(this.styleExp + "[value='4']").is(":checked") ? " underline" : "";
                                    s += $(this.styleExp + "[value='8']").is(":checked") ? " line-through" : "";
                                    css.textDecoration = s.trim();
                                    css.color = $(this.colorExp).val();
                                    return css;
                                }
                            };
                            $.TitleStyle.init();
                        </script>
                    </asp:Panel>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtContent">正文:</asp:Label>
                    <a href="Upfile.htm" onclick="javascript:$.fancybox(this.href + '?ID=Content,' + upfilePar, { width: '75%', height: '90%', transitionIn: 'none', transitionOut: 'none', type: 'iframe' });return false;">
                        插入文件/图片</a><br />
                    <asp:TextBox runat="server" ID="txtContent" TextMode="MultiLine"></asp:TextBox>
                    <span class="hit">Enter键入&lt;p&gt;，Shift+Enter键入&lt;br /&gt;</span>
                    <script type="text/javascript">
                        var fckContent = new FCKeditor(Page.ContentID);
                        fckContent.ToolbarSet = "ynhtm.Content";
                        fckContent.Height = "400px";
                        fckContent.ReplaceTextarea(); 
                    </script>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtTags">标签:</asp:Label>
                    <span class="hit">多个标签用空格隔开</span><br />
                    <asp:TextBox ID="txtTags" runat="server" Width="80%"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtSummary">摘要:</asp:Label>
                    <span class="gray"><a href="javascript:GetSummary();">从正文提取全部</a> - <a href="javascript:GetSummary(200);">
                        部分</a></span><br />
                    <asp:TextBox runat="server" ID="txtSummary" TextMode="MultiLine"></asp:TextBox>
                    <script type="text/javascript">
                        var fckSummary = new FCKeditor(Page.SummaryID);
                        fckSummary.ToolbarSet = "ynhtm.Summary";
                        fckSummary.Height = "100px";
                        fckSummary.ReplaceTextarea(); 
                    </script>
                </td>
            </tr>
        </table>
    </div>
</asp:Content>
