﻿using System;

namespace ynhtm.Admin
{
    using Common;

    public partial class Setting : System.Web.UI.Page
    {
        void SetValue(Model.Setting item)
        {
            item.SiteName = this.txtSiteName.Text;
            item.SiteUrl = this.txtSiteUrl.Text;
            item.MetaKeyWord = this.txtMetaKeyWord.Text;
            item.MetaDescr = this.txtMetaDescr.Text;
            item.TotalType = this.dropTotalType.Get(int.Parse);
            item.SiteEnabled = this.chkSiteEnabled.Checked;
            item.AuthcodeEnabled = this.chkAuthcodeEnabled.Checked;
            item.MapEnabled = this.chkMapEnabled.Checked;
            item.MapRowCount = this.txtMapRowCount.Get(int.Parse);
            item.WapEnabled = this.chkWapEnabled.Checked;
            item.WapDomain = this.txtWapDomain.Text;
            item.OAuthQzoneEnabled = this.chkOAuthQzoneEnabled.Checked;
            item.OAuthQzoneAppID = this.txtOAuthQzoneAppID.Text;
            item.OAuthQzoneAppKey = this.txtOAuthQzoneAppKey.Text;
            item.CacheEnabled = this.chkCacheEnabled.Checked;
            item.CacheExpire = this.txtCacheExpire.Get(int.Parse);
            item.CacheType = this.dropCacheType.Get(int.Parse);
            item.RssEnabled = this.chkRssEnabled.Checked;
            item.RssRowCount = this.txtRssRowCount.Get(int.Parse);
            item.RssShowType = this.dropRssShowType.Get(int.Parse);
            item.CommentEnabled = this.chkCommentEnabled.Checked;
            item.CommentSort = this.dropCommentSort.Get(int.Parse);
            item.CommentAudit = this.dropCommentAudit.Get(int.Parse);
            item.CommentDirty = this.txtCommentDirty.Text;
            item.CommentPageSize = this.txtCommentPageSize.Get(int.Parse);
            item.PageSize = this.txtPageSize.Get(int.Parse);
            item.PicMaskEnabled = this.chkPicMaskEnabled.Checked;
            item.PicMaskFile = this.txtPicMaskFile.Text;
            item.PicMaskPos = this.dropPicMaskPos.Get(int.Parse);
            item.PicQuality = this.dropPicQuality.Get(int.Parse);
            item.CodeHead = this.txtCodeHead.Text;
            item.CodeFoot = this.txtCodeFoot.Text;
        }

        void PageBind()
        {
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            this.txtSiteName.Text = settingItem.SiteName;
            this.txtSiteUrl.Text = settingItem.SiteUrl;
            this.txtMetaKeyWord.Text = settingItem.MetaKeyWord;
            this.txtMetaDescr.Text = settingItem.MetaDescr;
            this.dropTotalType.SelectValue(settingItem.TotalType.ToString());
            this.chkSiteEnabled.Checked = settingItem.SiteEnabled;
            this.chkAuthcodeEnabled.Checked = settingItem.AuthcodeEnabled;
            this.chkMapEnabled.Checked = settingItem.MapEnabled;
            this.txtMapRowCount.Text = settingItem.MapRowCount.ToString();
            this.chkWapEnabled.Checked = settingItem.WapEnabled;
            this.txtWapDomain.Text = settingItem.WapDomain;
            this.chkOAuthQzoneEnabled.Checked = settingItem.OAuthQzoneEnabled;
            this.txtOAuthQzoneAppID.Text = settingItem.OAuthQzoneAppID;
            this.txtOAuthQzoneAppKey.Text = settingItem.OAuthQzoneAppKey;
            this.chkCacheEnabled.Checked = settingItem.CacheEnabled;
            this.txtCacheExpire.Text = settingItem.CacheExpire.ToString();
            this.dropCacheType.SelectValue(settingItem.CacheType.ToString());
            this.chkRssEnabled.Checked = settingItem.RssEnabled;
            this.txtRssRowCount.Text = settingItem.RssRowCount.ToString();
            this.dropRssShowType.SelectValue(settingItem.RssShowType.ToString());
            this.chkCommentEnabled.Checked = settingItem.CommentEnabled;
            this.dropCommentSort.SelectValue(settingItem.CommentSort.ToString());
            this.dropCommentAudit.SelectValue(settingItem.CommentAudit.ToString());
            this.txtCommentDirty.Text = settingItem.CommentDirty;
            this.txtCommentPageSize.Text = settingItem.CommentPageSize.ToString();
            this.txtPageSize.Text = settingItem.PageSize.ToString();
            this.chkPicMaskEnabled.Checked = settingItem.PicMaskEnabled;
            this.txtPicMaskFile.Text = settingItem.PicMaskFile;
            this.dropPicMaskPos.SelectValue(settingItem.PicMaskPos.ToString());
            this.dropPicQuality.SelectValue(settingItem.PicQuality.ToString());
            this.txtCodeHead.Text = settingItem.CodeHead;
            this.txtCodeFoot.Text = settingItem.CodeFoot;
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            this.Form.DefaultButton = this.btnSave.UniqueID;
            if (!this.IsPostBack)
            {
                this.PageBind();
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (this.IsValid)
            {
                var setting = new BLL.Setting();
                var item = setting.Get();
                this.SetValue(item);
                setting.Update(item);
                this.ShowInfo("保存设置成功");
            }
        }
    }
}