﻿using System;
using System.Collections;
using System.IO;
using System.Web.UI.WebControls;
using System.Xml.Linq;

namespace ynhtm.Admin
{
    using Common;

    public partial class ThemeList : System.Web.UI.Page
    {
        void CopyDir(string sourcePath, string destPath)
        {
            var dir = new DirectoryInfo(sourcePath);
            if (!dir.Exists) return;
            Directory.CreateDirectory(destPath);
            foreach (var i in dir.GetFiles()) i.CopyTo(Path.Combine(destPath, i.Name), true);
            foreach (var i in dir.GetDirectories()) this.CopyDir(i.FullName, Path.Combine(destPath, i.Name));
        }

        void PageBind()
        {
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            var list = new ArrayList();
            var dir = new DirectoryInfo(this.Server.MapPath("~/Theme/"));
            foreach (var i in dir.GetDirectories())
            {
                var path = Path.Combine(i.FullName, "Theme.xml");
                if (File.Exists(path))
                {
                    var xml = XElement.Load(path);
                    var wap = xml.Element("wap").Value != "0";
                    list.Add(new
                    {
                        Use = string.Equals(i.Name, settingItem.Theme, StringComparison.OrdinalIgnoreCase) || (wap && string.Equals(i.Name, settingItem.WapTheme, StringComparison.OrdinalIgnoreCase)),
                        Wap = wap,
                        Path = i.Name,
                        Name = xml.Element("name").Value,
                        Version = xml.Element("version").Value,
                        Author = xml.Element("author").Value,
                        Url = xml.Element("url").Value
                    });
                }
            }
            this.rptList.DataSource = list;
            this.rptList.DataBind();
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.IsPostBack)
            {
                this.PageBind();
            }
        }

        protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
#if DEMO
            this.ShowAlert("演示版无法操作");
            return;
#endif
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            if (e.CommandName == "Use")
            {
                settingItem.Theme = e.CommandArgument.ToString();
                setting.Update(settingItem);
                this.PageBind();
                this.ShowInfo("使用主题成功");
            }
            else if (e.CommandName == "UseWap")
            {
                settingItem.WapTheme = e.CommandArgument.ToString();
                setting.Update(settingItem);
                this.PageBind();
                this.ShowInfo("使用主题成功");
            }
            else if (e.CommandName == "Copy")
            {
                var name = e.CommandArgument.ToString();
                var index = 1;
                while (Directory.Exists(this.Server.MapPath("~/Theme/" + name + "_" + index))) index++;
                this.CopyDir(this.Server.MapPath("~/Theme/" + name), this.Server.MapPath("~/Theme/" + name + "_" + index));
                this.PageBind();
                this.ShowInfo("复制主题成功");
            }
            else if (e.CommandName == "Del")
            {
                Directory.Delete(this.Server.MapPath("~/Theme/" + e.CommandArgument), true);
                this.PageBind();
                this.ShowInfo("删除主题成功");
            }
        }
    }
}