﻿<%@ Page Title="栏目管理 - 管理中心" Language="C#" MasterPageFile="Frame.master" AutoEventWireup="true"
    CodeBehind="CategoryList.aspx.cs" Inherits="ynhtm.Admin.CategoryList" %>

<%@ Register Assembly="ynhtm.WebControls" Namespace="ynhtm.WebControls" TagPrefix="YNHTM" %>
<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        栏目管理</h1>
</asp:Content>
<asp:Content ID="contentRight" ContentPlaceHolderID="contentRightPlaceHolder" runat="server">
    <h2>
        <asp:Label ID="lblSubTitle" runat="server"></asp:Label></h2>
    <asp:Panel runat="server" DefaultButton="btnEdit" CssClass="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtName">名称:</asp:Label><br />
                    <asp:TextBox ID="txtName" runat="server" Width="243px" ValidationGroup="Form"></asp:TextBox>
                    <asp:RequiredFieldValidator runat="server" ControlToValidate="txtName" ErrorMessage="名称不能为空"
                        ValidationGroup="Form"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="chkRssEnabled" runat="server" Text="RSS 订阅" Checked="True" />
                    <asp:CheckBox ID="chkMapEnabled" runat="server" Text="站点地图" Checked="True" />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtRewrite">重写地址:</asp:Label><br />
                    <asp:TextBox ID="txtRewrite" runat="server" Width="243px" ValidationGroup="Form"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="dropHomeTheme">首页模板:</asp:Label><br />
                    <asp:DropDownList ID="dropHomeTheme" runat="server" Width="250px" ValidationGroup="Form">
                        <asp:ListItem Value="">(无首页)</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="dropListTheme">列表模板:</asp:Label><br />
                    <asp:DropDownList ID="dropListTheme" runat="server" Width="250px" ValidationGroup="Form">
                        <asp:ListItem Value="">(默认)</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="dropPostTheme">文章模板:</asp:Label><br />
                    <asp:DropDownList ID="dropPostTheme" runat="server" Width="250px" ValidationGroup="Form">
                        <asp:ListItem Value="">(默认)</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtDisplayOrder">排序:</asp:Label><br />
                    <asp:TextBox ID="txtDisplayOrder" runat="server" Width="50px" ValidationGroup="Form">1000</asp:TextBox>
                    <span class="hit">越小越靠前</span>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Button ID="btnEdit" runat="server" OnClick="btnEdit_Click" ValidationGroup="Form" UseSubmitBehavior="false" />
                    <asp:Button ID="btnCancel" runat="server" Text="取消" CausesValidation="false" UseSubmitBehavior="false"
                        OnClick="btnCancel_Click" />
                </td>
            </tr>
        </table>
    </asp:Panel>
</asp:Content>
<asp:Content ID="contentLeft" ContentPlaceHolderID="contentLeftPlaceHolder" runat="server">
    <table class="list list-space" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th style="width: 60px;" class="center">
                    编号
                </th>
                <th>
                    名称
                </th>
                <th style="width: 80px;" class="center">
                    文章/评论
                </th>
                <th style="width: 60px;" class="center">
                    排序
                </th>
                <th style="width: 80px;" class="center">
                    创建日期
                </th>
                <th style="width: 110px;" class="center">
                    操作
                </th>
            </tr>
        </thead>
        <tbody>
            <YNHTM:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
                <EmptyTemplate>
                    <tr class="list-empty">
                        <td colspan="6">
                            没有任何栏目
                        </td>
                    </tr>
                </EmptyTemplate>
                <ItemTemplate>
                    <tr>
                        <td class="center">
                            <asp:HiddenField ID="hidSelectID" runat="server" Value='<%#this.Eval("CategoryID")%>' />
                            <%#this.Eval("CategoryID")%>
                        </td>
                        <td>
                            <asp:TextBox ID="txtName" runat="server" Text='<%#this.Eval("Name")%>' Width="60%"></asp:TextBox>
                        </td>
                        <td class="center">
                            <%#this.Eval("PostCount")%>/<%#this.Eval("CommentCount")%>
                        </td>
                        <td class="center" style="padding: 0;">
                            <asp:TextBox ID="txtDisplayOrder" runat="server" Text='<%#this.Eval("DisplayOrder")%>'
                                Width="35px"></asp:TextBox>
                        </td>
                        <td class="center">
                            <%#this.Eval("CreateDate","{0:yyy-MM-dd}")%>
                        </td>
                        <td class="center gray">
                            <a href="<%#this.Eval("Url")%>" target="_blank" class="b">查看</a>
                            |
                            <asp:LinkButton runat="server" CssClass="b" CausesValidation="false" CommandName="Edit" CommandArgument='<%#this.Eval("CategoryID")%>'>编辑</asp:LinkButton>
                            |
                            <asp:LinkButton runat="server" CssClass="b" CausesValidation="false" CommandName="Del" CommandArgument='<%#this.Eval("CategoryID")%>'
                                OnClientClick="javascript:if(!confirm('确认删除该栏目吗？')) return false;">删除</asp:LinkButton>
                        </td>
                    </tr>
                </ItemTemplate>
            </YNHTM:Repeater>
        </tbody>
    </table>
    <div class="command">
        <asp:Button ID="btnUpdateList" runat="server" Text="更新列表" CausesValidation="false"
            UseSubmitBehavior="false" OnClick="btnUpdateList_Click" />
    </div>
</asp:Content>
