﻿<%@ Page Title="网站设置 - 管理中心" Language="C#" MasterPageFile="Page.Master" AutoEventWireup="true"
    CodeBehind="Setting.aspx.cs" Inherits="ynhtm.Admin.Setting" %>

<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        网站设置</h1>
</asp:Content>
<asp:Content ID="content" ContentPlaceHolderID="contentPlaceHolder" runat="server">
    <h2>
        基本设置</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtSiteName">网站标题:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtSiteName" runat="server" Width="40%"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtSiteUrl">网站地址:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtSiteUrl" runat="server" Width="40%"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtMetaKeyWord">Meta Keywords:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtMetaKeyWord" runat="server" Width="70%"></asp:TextBox>
                    <span class="hit">首页关键字，用逗号“,”隔开</span>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtMetaDescr">Meta Description:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtMetaDescr" runat="server" Width="70%"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="chkSiteEnabled">网站状态:</asp:Label>
                </td>
                <td>
                    <asp:CheckBox ID="chkSiteEnabled" runat="server" Text="开启" />
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="chkAuthcodeEnabled">验证码:</asp:Label>
                </td>
                <td>
                    <asp:CheckBox ID="chkAuthcodeEnabled" runat="server" Text="启用" />
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="dropTotalType">文章统计:</asp:Label>
                </td>
                <td>
                    <asp:DropDownList ID="dropTotalType" runat="server" Width="184px">
                        <asp:ListItem Value="1">刷新一次增加一次</asp:ListItem>
                        <asp:ListItem Value="2">一天只增加一次(Cookie)</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="chkMapEnabled">站点地图:</asp:Label>
                </td>
                <td>
                    <asp:CheckBox ID="chkMapEnabled" runat="server" Text="启用" />
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="chkWapEnabled">手机网站:</asp:Label>
                </td>
                <td>
                    <asp:CheckBox ID="chkWapEnabled" runat="server" Text="启用" />
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtWapDomain">手机网站域:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtWapDomain" runat="server" Width="176px"></asp:TextBox>
                </td>
            </tr>
        </table>
    </div>
    <h2>
        QQ账号登录</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td class="lab">
                </td>
                <td class="gray">
                   还没有接入? <a href="http://connect.opensns.qq.com/" class="b" target="_blank">申请网站接入</a>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="chkOAuthQzoneEnabled">状态:</asp:Label>
                </td>
                <td>
                    <asp:CheckBox ID="chkOAuthQzoneEnabled" runat="server" Text="启用" />
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtOAuthQzoneAppID">APP ID:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtOAuthQzoneAppID" runat="server" Width="176px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtOAuthQzoneAppKey">APP Key:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtOAuthQzoneAppKey" runat="server" Width="40%"></asp:TextBox>
                </td>
            </tr>
        </table>
    </div>
    <h2>
        缓存设置</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="chkCacheEnabled">状态:</asp:Label>
                </td>
                <td>
                    <asp:CheckBox ID="chkCacheEnabled" runat="server" Text="启用" />
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtCacheExpire">过期时间:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtCacheExpire" runat="server" Width="50px"></asp:TextBox>
                    分钟
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="dropCacheType">缓存方式:</asp:Label>
                </td>
                <td>
                    <asp:DropDownList ID="dropCacheType" runat="server" Width="184px">
                        <asp:ListItem Value="2">客户端(代理服务器不缓存)</asp:ListItem>
                        <asp:ListItem Value="3">服务器</asp:ListItem>
                        <asp:ListItem Value="4">客户端和代理</asp:ListItem>
                        <asp:ListItem Value="5">服务器、客户端和代理</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
        </table>
    </div>
    <h2>
        评论设置</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="chkCommentEnabled">状态:</asp:Label>
                </td>
                <td>
                    <asp:CheckBox ID="chkCommentEnabled" runat="server" Text="启用" />
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="dropCommentSort">排序模式:</asp:Label>
                </td>
                <td>
                    <asp:DropDownList ID="dropCommentSort" runat="server" Width="184px">
                        <asp:ListItem Value="0">顺序(默认)</asp:ListItem>
                        <asp:ListItem Value="1">倒序(后发表的在前面)</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="dropCommentAudit">审核方式:</asp:Label>
                </td>
                <td>
                    <asp:DropDownList ID="dropCommentAudit" runat="server" Width="184px">
                        <asp:ListItem Value="1">无需审核</asp:ListItem>
                        <asp:ListItem Value="2">自动审核(配合垃圾词语)</asp:ListItem>
                        <asp:ListItem Value="3">人工审核</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtCommentDirty">垃圾词语:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtCommentDirty" runat="server" TextMode="MultiLine" Width="70%"
                        Rows="5"></asp:TextBox><br />
                    <span class="hit">多个词语以“,”分隔，当审核类型为“自动审核”时，评论包括这些关键字，则该评论转为待审核，否则审核通过</span>
                </td>
            </tr>
        </table>
    </div>
    <h2>
        RSS 设置</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="chkRssEnabled">状态:</asp:Label>
                </td>
                <td>
                    <asp:CheckBox ID="chkRssEnabled" runat="server" Text="启用" />
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="dropRssShowType">输出方式:</asp:Label>
                </td>
                <td>
                    <asp:DropDownList ID="dropRssShowType" runat="server" Width="184px">
                        <asp:ListItem Value="1">仅标题</asp:ListItem>
                        <asp:ListItem Value="2">摘要</asp:ListItem>
                        <asp:ListItem Value="3">正文前200字</asp:ListItem>
                        <asp:ListItem Value="4">正文</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtRssRowCount">RSS输出条数:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtRssRowCount" runat="server" Width="50px"></asp:TextBox>
                </td>
            </tr>
        </table>
    </div>
    <h2>
        显示设置</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtPageSize">每页文章数:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtPageSize" runat="server" Width="50px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtCommentPageSize">每页评论数:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtCommentPageSize" runat="server" Width="50px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtMapRowCount">站点地图输出条数:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtMapRowCount" runat="server" Width="50px"></asp:TextBox>
                </td>
            </tr>
        </table>
    </div>
    <h2>
        水印图片 <span class="hit">(上传附件为图片时使用)</span></h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="chkPicMaskEnabled">水印:</asp:Label>
                </td>
                <td>
                    <asp:CheckBox ID="chkPicMaskEnabled" runat="server" Text="启用" />
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtPicMaskFile">水印图片文件:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtPicMaskFile" runat="server" Width="176px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="dropPicMaskPos">水印位置:</asp:Label>
                </td>
                <td>
                    <asp:DropDownList ID="dropPicMaskPos" runat="server" Width="184px">
                        <asp:ListItem Value="1">上左</asp:ListItem>
                        <asp:ListItem Value="4">上右</asp:ListItem>
                        <asp:ListItem Value="256">下左</asp:ListItem>
                        <asp:ListItem Value="1024">下右</asp:ListItem>
                        <asp:ListItem Value="32">居中</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="dropPicQuality">保存图片质量:</asp:Label>
                </td>
                <td>
                    <asp:DropDownList ID="dropPicQuality" runat="server" Width="184px">
                        <asp:ListItem Value="10">10%</asp:ListItem>
                        <asp:ListItem Value="15">15%</asp:ListItem>
                        <asp:ListItem Value="20">20%</asp:ListItem>
                        <asp:ListItem Value="25">25%</asp:ListItem>
                        <asp:ListItem Value="30">30%</asp:ListItem>
                        <asp:ListItem Value="35">35%</asp:ListItem>
                        <asp:ListItem Value="40">40%</asp:ListItem>
                        <asp:ListItem Value="45">45%</asp:ListItem>
                        <asp:ListItem Value="50">50%</asp:ListItem>
                        <asp:ListItem Value="55">55%</asp:ListItem>
                        <asp:ListItem Value="60">60%</asp:ListItem>
                        <asp:ListItem Value="65">65%</asp:ListItem>
                        <asp:ListItem Value="70">70%</asp:ListItem>
                        <asp:ListItem Value="75">75%</asp:ListItem>
                        <asp:ListItem Value="80">80% (推荐)</asp:ListItem>
                        <asp:ListItem Value="85">85%</asp:ListItem>
                        <asp:ListItem Value="90">90%</asp:ListItem>
                        <asp:ListItem Value="95">95%</asp:ListItem>
                        <asp:ListItem Value="100">100%</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
        </table>
    </div>
    <h2>
        外部代码 <span class="hit">(支持HTML)</span></h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtCodeHead">页头内容:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtCodeHead" runat="server" TextMode="MultiLine" Width="70%" Rows="5"></asp:TextBox><br />
                    <span class="hit">在&lt;head&gt;&lt;/head&gt;之间插入代码块</span>
                </td>
            </tr>
            <tr>
                <td class="lab">
                    <asp:Label runat="server" AssociatedControlID="txtCodeFoot">页脚内容:</asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtCodeFoot" runat="server" TextMode="MultiLine" Width="70%" Rows="5"></asp:TextBox><br />
                    <span class="hit">网站统计，备案号等可放于此</span>
                </td>
            </tr>
            <tr>
                <td class="lab">
                </td>
                <td>
                    <asp:Button ID="btnSave" runat="server" OnClick="btnSave_Click" Text="保存设置" Font-Bold="true" />
                </td>
            </tr>
        </table>
    </div>
</asp:Content>
