﻿<%@ Page Title="编辑主题 - 管理中心" Language="C#" MasterPageFile="Frame.master" AutoEventWireup="true"
    CodeBehind="ThemeEdit.aspx.cs" Inherits="ynhtm.Admin.ThemeEdit" %>

<%@ Register Assembly="ynhtm.WebControls" Namespace="ynhtm.WebControls" TagPrefix="YNHTM" %>
<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        <asp:label id="lblTitle" runat="server"></asp:label>
    </h1>
</asp:Content>
<asp:Content ID="contentRight" ContentPlaceHolderID="contentRightPlaceHolder" runat="server">
    <h2>
        新建文件</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:label runat="server" validationgroup="Form" associatedcontrolid="txtName">文件名:</asp:label>
                    <br />
                    <asp:textbox id="txtName" runat="server" width="243px"></asp:textbox>
                    <asp:requiredfieldvalidator runat="server" controltovalidate="txtName" errormessage="文件名不能为空"
                        validationgroup="Form"></asp:requiredfieldvalidator>
                    <asp:regularexpressionvalidator runat="server" errormessage="文件名不正确" controltovalidate="txtName"
                        validationexpression="\w+\.(htm|html|css|txt|xml|cshtml|vbhtml)$" validationgroup="Form"></asp:regularexpressionvalidator>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:button id="btnNew" runat="server" onclick="btnNew_Click" text="新建" usesubmitbehavior="false"
                        validationgroup="Form" />
                </td>
            </tr>
        </table>
    </div>
    <table class="list" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th>
                    文件名
                </th>
                <th style="width: 100px;" class="center">
                    大小
                </th>
                <th style="width: 50px;" class="center">
                    操作
                </th>
            </tr>
        </thead>
        <YNHTM:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
            <ItemTemplate>
                <tr>
                    <td>
                        <asp:linkbutton runat="server" causesvalidation="false" commandname="Edit" commandargument='<%#this.Eval("Name")%>'><%#this.Eval<string>("Name").HtmlEncode()%></asp:linkbutton>
                    </td>
                    <td class="center">
                        <%#this.EvalLength%>
                    </td>
                    <td class="center">
                        <asp:linkbutton runat="server" causesvalidation="false" commandname="Del" commandargument='<%#this.Eval("Name")%>'
                            onclientclick="javascript:if(!confirm('确认删除该文件吗？')) return false;">删除</asp:linkbutton>
                    </td>
                </tr>
            </ItemTemplate>
        </YNHTM:Repeater>
    </table>
</asp:Content>
<asp:Content ID="contentLeft" ContentPlaceHolderID="contentLeftPlaceHolder" runat="server">
    <h2>
        编辑内容</h2>
    <div class="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:label id="lblPath" runat="server">没有选择任何文件</asp:label>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:textbox id="txtContent" runat="server" textmode="MultiLine" width="98%" rows="28"></asp:textbox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:button id="btnSave" runat="server" onclick="btnSave_Click" text="保存文件" font-bold="true" />
                    <input type="button" value="返回" class="btn" onclick="javascript:location = 'ThemeList.aspx';" />
                </td>
            </tr>
        </table>
    </div>
</asp:Content>
