using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;
//5/1/a/s/px
namespace AVC.Business
{
	public class BusLineBiz
	{
		public static void AddBusLine(BusLine objBusLine)
		{
			BusLineInsert objBusLineDAL = new BusLineInsert();
			objBusLineDAL.ReceiveParameter(objBusLine);
			objBusLineDAL.ExecuteNonQuery();
			objBusLine.Id = objBusLineDAL.Id;
		}

		public static DataTable GetAllBusLine()
		{
			BusLineSelectAll objBusLineDAL = new BusLineSelectAll();
			return objBusLineDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetBusLineSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        BusLineSelectAllPaged objBusLineDAL = new BusLineSelectAllPaged();
	        objBusLineDAL.CurrentPage = CurrentPage;
	        objBusLineDAL.PageSize = PageSize;
	        objBusLineDAL.SortBy = SortBy;
	        DataTable BusLineTable =  objBusLineDAL.ExecuteDataTable();
	        TotalPage = objBusLineDAL.TotalPage;
	        TotalRecord = objBusLineDAL.TotalRecord;
	        return BusLineTable;
	     }

		public static void UpdateBusLine(BusLine objBusLine)
		{
			BusLineUpdate objBusLineDAL = new BusLineUpdate();
			objBusLineDAL.ReceiveParameter(objBusLine);
			objBusLineDAL.ExecuteNonQuery();
		}

		public static void DeleteBusLine(System.Int32 Id)
		{
			BusLineDelete objBusLineDAL = new BusLineDelete();
			objBusLineDAL.Id = Id;
			objBusLineDAL.ExecuteNonQuery();
		}

		public static BusLine GetBusLine(System.Int32 Id)
		{
			BusLineSelectByPk objBusLineDAL = new BusLineSelectByPk();
			BusLine objBusLine = new BusLine();
			objBusLineDAL.Id = Id;
			objBusLine.SetMetaDataTable(objBusLineDAL.ExecuteDataTable());
			return objBusLine;
		}
	}
}