using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class CarBiz
	{
		public static void AddCar(Car objCar)
		{
			CarInsert objCarDAL = new CarInsert();
			objCarDAL.ReceiveParameter(objCar);
			objCarDAL.ExecuteNonQuery();
			objCar.ID = objCarDAL.ID;
		}

		public static DataTable GetAllCar()
		{
			CarSelectAll objCarDAL = new CarSelectAll();
			return objCarDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetCarSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        CarSelectAllPaged objCarDAL = new CarSelectAllPaged();
	        objCarDAL.CurrentPage = CurrentPage;
	        objCarDAL.PageSize = PageSize;
	        objCarDAL.SortBy = SortBy;
	        DataTable CarTable =  objCarDAL.ExecuteDataTable();
	        TotalPage = objCarDAL.TotalPage;
	        TotalRecord = objCarDAL.TotalRecord;
	        return CarTable;
	     }

		public static void UpdateCar(Car objCar)
		{
			CarUpdate objCarDAL = new CarUpdate();
			objCarDAL.ReceiveParameter(objCar);
			objCarDAL.ExecuteNonQuery();
		}

		public static void DeleteCar(System.Int32 ID)
		{
			CarDelete objCarDAL = new CarDelete();
			objCarDAL.ID = ID;
			objCarDAL.ExecuteNonQuery();
		}

		public static Car GetCar(System.Int32 ID)
		{
			CarSelectByPk objCarDAL = new CarSelectByPk();
			Car objCar = new Car();
			objCarDAL.ID = ID;
			objCar.SetMetaDataTable(objCarDAL.ExecuteDataTable());
			return objCar;
		}
	}
}