using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class CarEmployeeBiz
	{
		public static void AddCarEmployee(CarEmployee objCarEmployee)
		{
			CarEmployeeInsert objCarEmployeeDAL = new CarEmployeeInsert();
			objCarEmployeeDAL.ReceiveParameter(objCarEmployee);
			objCarEmployeeDAL.ExecuteNonQuery();
			objCarEmployee.ID = objCarEmployeeDAL.ID;
		}

		public static DataTable GetAllCarEmployee()
		{
			CarEmployeeSelectAll objCarEmployeeDAL = new CarEmployeeSelectAll();
			return objCarEmployeeDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetCarEmployeeSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        CarEmployeeSelectAllPaged objCarEmployeeDAL = new CarEmployeeSelectAllPaged();
	        objCarEmployeeDAL.CurrentPage = CurrentPage;
	        objCarEmployeeDAL.PageSize = PageSize;
	        objCarEmployeeDAL.SortBy = SortBy;
	        DataTable CarEmployeeTable =  objCarEmployeeDAL.ExecuteDataTable();
	        TotalPage = objCarEmployeeDAL.TotalPage;
	        TotalRecord = objCarEmployeeDAL.TotalRecord;
	        return CarEmployeeTable;
	     }

		public static void UpdateCarEmployee(CarEmployee objCarEmployee)
		{
			CarEmployeeUpdate objCarEmployeeDAL = new CarEmployeeUpdate();
			objCarEmployeeDAL.ReceiveParameter(objCarEmployee);
			objCarEmployeeDAL.ExecuteNonQuery();
		}

		public static void DeleteCarEmployee(System.Int32 ID)
		{
			CarEmployeeDelete objCarEmployeeDAL = new CarEmployeeDelete();
			objCarEmployeeDAL.ID = ID;
			objCarEmployeeDAL.ExecuteNonQuery();
		}

		public static CarEmployee GetCarEmployee(System.Int32 ID)
		{
			CarEmployeeSelectByPk objCarEmployeeDAL = new CarEmployeeSelectByPk();
			CarEmployee objCarEmployee = new CarEmployee();
			objCarEmployeeDAL.ID = ID;
			objCarEmployee.SetMetaDataTable(objCarEmployeeDAL.ExecuteDataTable());
			return objCarEmployee;
		}

		public static DataTable GetCarEmployeeByCarID(System.Int32 CarID)
		{
			CarEmployeeSelectByCarID objCarEmployeeDAL = new CarEmployeeSelectByCarID();
			objCarEmployeeDAL.CarID = CarID;
			return objCarEmployeeDAL.ExecuteDataTable();
		}
	}
}