using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class OptionalValueBiz
	{
		public static void AddOptionalValue(OptionalValue objOptionalValue)
		{
			OptionalValueInsert objOptionalValueDAL = new OptionalValueInsert();
			objOptionalValueDAL.ReceiveParameter(objOptionalValue);
			objOptionalValueDAL.ExecuteNonQuery();
			objOptionalValue.ID = objOptionalValueDAL.ID;
		}

		public static DataTable GetAllOptionalValue()
		{
			OptionalValueSelectAll objOptionalValueDAL = new OptionalValueSelectAll();
			return objOptionalValueDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetOptionalValueSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        OptionalValueSelectAllPaged objOptionalValueDAL = new OptionalValueSelectAllPaged();
	        objOptionalValueDAL.CurrentPage = CurrentPage;
	        objOptionalValueDAL.PageSize = PageSize;
	        objOptionalValueDAL.SortBy = SortBy;
	        DataTable OptionalValueTable =  objOptionalValueDAL.ExecuteDataTable();
	        TotalPage = objOptionalValueDAL.TotalPage;
	        TotalRecord = objOptionalValueDAL.TotalRecord;
	        return OptionalValueTable;
	     }

		public static void UpdateOptionalValue(OptionalValue objOptionalValue)
		{
			OptionalValueUpdate objOptionalValueDAL = new OptionalValueUpdate();
			objOptionalValueDAL.ReceiveParameter(objOptionalValue);
			objOptionalValueDAL.ExecuteNonQuery();
		}

		public static void DeleteOptionalValue(System.Int32 ID)
		{
			OptionalValueDelete objOptionalValueDAL = new OptionalValueDelete();
			objOptionalValueDAL.ID = ID;
			objOptionalValueDAL.ExecuteNonQuery();
		}

		public static OptionalValue GetOptionalValue(System.Int32 ID)
		{
			OptionalValueSelectByPk objOptionalValueDAL = new OptionalValueSelectByPk();
			OptionalValue objOptionalValue = new OptionalValue();
			objOptionalValueDAL.ID = ID;
			objOptionalValue.SetMetaDataTable(objOptionalValueDAL.ExecuteDataTable());
			return objOptionalValue;
		}

        public static DataTable GetOptionValueByDescription( System.String Description)
        {
            OptionalValueSelectByDescription objOptionalValueDAL = new OptionalValueSelectByDescription();
            objOptionalValueDAL.Description = Description;
            return objOptionalValueDAL.ExecuteDataTable();
            
        }
	}
}