﻿namespace ESpace.DALibrary.OleDb
{
    using ESpace.DALibrary;
    using System;
    using System.Configuration;
    using System.Data;
    using System.Data.OleDb;
    using System.Reflection;

    public class DataAccessBase : IDisposable
    {
        private Alogrim.SymmProvEnum _EncryptMethod;
        private string _IV;
        private string _Key;
        private string _strConn;
        private bool disposed;
        protected OleDbCommand oleComm;
        protected OleDbParameter paramReturnValue;

        private string Decrypt(string strSource)
        {
            if (this._EncryptMethod == Alogrim.SymmProvEnum.None)
            {
                return strSource;
            }
            Alogrim alogrim = new Alogrim(this._EncryptMethod);
            alogrim.Key = this._Key;
            alogrim.IV = this._IV;
            return alogrim.Decrypting(strSource);
        }

        public void Dispose()
        {
            if (!this.disposed)
            {
                if (this.oleComm != null)
                {
                    if (this.oleComm.Connection != null)
                    {
                        this.oleComm.Connection.Dispose();
                    }
                    this.oleComm.Dispose();
                }
                this.disposed = true;
            }
        }

        public DataSet ExecuteDataSet()
        {
            return this.ExecuteDataSet("Root");
        }

        public DataSet ExecuteDataSet(string sTableName)
        {
            DataSet set;
            using (OleDbConnection connection = new OleDbConnection(this._strConn))
            {
                this.oleComm.Connection = connection;
                OleDbDataAdapter adapter = new OleDbDataAdapter(this.oleComm);
                set = new DataSet(sTableName);
                adapter.Fill(set);
                connection.Close();
            }
            return set;
        }

        public DataTable ExecuteDataTable()
        {
            return this.ExecuteDataTable("");
        }

        public DataTable ExecuteDataTable(string sTableName)
        {
            DataTable table;
            using (OleDbConnection connection = new OleDbConnection(this._strConn))
            {
                this.oleComm.Connection = connection;
                OleDbDataAdapter adapter = new OleDbDataAdapter(this.oleComm);
                table = new DataTable();
                adapter.Fill(table);
                connection.Close();
                if (sTableName != "")
                {
                    table.TableName = sTableName;
                }
            }
            return table;
        }

        public int ExecuteNonQuery()
        {
            int num = -1;
            using (OleDbConnection connection = new OleDbConnection(this._strConn))
            {
                connection.Open();
                this.oleComm.Connection = connection;
                num = this.oleComm.ExecuteNonQuery();
                connection.Close();
            }
            return num;
        }

        public object ExecuteScalar()
        {
            object obj2 = null;
            using (OleDbConnection connection = new OleDbConnection(this._strConn))
            {
                this.oleComm.Connection = connection;
                connection.Open();
                this.oleComm.Connection = connection;
                obj2 = this.oleComm.ExecuteScalar();
                connection.Close();
            }
            return obj2;
        }

        protected void InitCommand(string sSPName)
        {
            this.oleComm = new OleDbCommand();
            this.oleComm.CommandText = sSPName;
            this.oleComm.CommandType = CommandType.StoredProcedure;
            this.paramReturnValue = new OleDbParameter();
            this.paramReturnValue.ParameterName = "@ReturnValue";
            this.paramReturnValue.OleDbType = OleDbType.Integer;
            this.paramReturnValue.Size = 4;
            this.paramReturnValue.Direction = ParameterDirection.ReturnValue;
            this.oleComm.Parameters.Add(this.paramReturnValue);
        }

        public void ReceiveParameter(DataTable dtParameter)
        {
            foreach (OleDbParameter parameter in this.oleComm.Parameters)
            {
                string parameterName = parameter.ParameterName;
                string str2 = parameterName.Substring(1, parameterName.Length - 1);
                foreach (DataColumn column in dtParameter.Columns)
                {
                    if (str2 == column.ColumnName)
                    {
                        parameter.Value = dtParameter.Rows[0][str2];
                        break;
                    }
                }
            }
        }

        public void ReceiveParameter(object objEntity)
        {
            Type type = objEntity.GetType();
            foreach (OleDbParameter parameter in this.oleComm.Parameters)
            {
                string parameterName = parameter.ParameterName;
                string name = parameterName.Substring(1, parameterName.Length - 1);
                PropertyInfo property = type.GetProperty(name);
                if (property != null)
                {
                    parameter.Value = property.GetValue(objEntity, null);
                }
            }
        }

        public string ConnectionString
        {
            get
            {
                return this._strConn;
            }
            set
            {
                this._strConn = this.Decrypt(value);
            }
        }

        public string DBSection
        {
            set
            {
                this._strConn = this.Decrypt(ConfigurationManager.AppSettings[value]);
            }
        }

        protected Alogrim.SymmProvEnum EncryptMethod
        {
            set
            {
                this._EncryptMethod = value;
            }
        }

        protected string IV
        {
            set
            {
                this._IV = value;
            }
        }

        protected string Key
        {
            set
            {
                this._Key = value;
            }
        }

        public int ReturnValue
        {
            get
            {
                return (int) this.paramReturnValue.Value;
            }
        }
    }
}

