using System;
using System.Data;
using AVC.Passport.DataEntity;
using AVC.Passport.DataAccess;

namespace AVC.Passport
{
	public class GroupBiz
	{
		public static void AddGroup(Group objGroup)
		{
			GroupInsert objGroupDAL = new GroupInsert();
			objGroupDAL.ReceiveParameter(objGroup);
			objGroupDAL.ExecuteNonQuery();
			objGroup.GroupID = objGroupDAL.GroupID;
		}

		public static DataTable GetAllGroup()
		{
			GroupSelectAll objGroupDAL = new GroupSelectAll();
			return objGroupDAL.ExecuteDataTable();
		}

        public static DataTable GetGroupSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
        {
            GroupSelectAllPaged objGroupDAL = new GroupSelectAllPaged();
            objGroupDAL.CurrentPage = CurrentPage;
            objGroupDAL.PageSize = PageSize;
            objGroupDAL.SortBy = SortBy;
            DataTable GroupTable = objGroupDAL.ExecuteDataTable();
            TotalPage = objGroupDAL.TotalPage;
            TotalRecord = objGroupDAL.TotalRecord;
            return GroupTable;
        }

		public static void UpdateGroup(Group objGroup)
		{
			GroupUpdate objGroupDAL = new GroupUpdate();
			objGroupDAL.ReceiveParameter(objGroup);
			objGroupDAL.ExecuteNonQuery();
		}

        public static void DeleteGroup(System.Int32 GroupID, String SubSystemID)
		{
			GroupDeleteA objGroupDAL = new GroupDeleteA();
			objGroupDAL.GroupID = GroupID;
            objGroupDAL.SubSystemID = SubSystemID;
			objGroupDAL.ExecuteNonQuery();
		}

        public static DataTable GetGroupBySubSystemIDAndParentID(string SubSystemID, int ParentGroupID)
        {
            GroupSelectBySubSystemIDAndParentID objGroupDAL = new GroupSelectBySubSystemIDAndParentID();
            objGroupDAL.ParentGroupID = ParentGroupID;
            objGroupDAL.SubSystemID = SubSystemID;

            return objGroupDAL.ExecuteDataTable();
        }

		public static DataTable GetGroupBySubSystemID(System.String SubSystemID)
		{
			GroupSelectBySubSystemID objGroupDAL = new GroupSelectBySubSystemID();
			objGroupDAL.SubSystemID = SubSystemID;
			return objGroupDAL.ExecuteDataTable();
		}

        public static DataTable GetAllRights(string SubSystemID,int GroupID)
        {
            GetGroupAllRights objGroupDAL = new GetGroupAllRights();
            objGroupDAL.GroupID = GroupID;
            objGroupDAL.SubSystemID = SubSystemID;
            return  objGroupDAL.ExecuteDataTable();
        }

        public static DataTable GetRights(int GroupID, string SubSystemID)
        {
            GetGroupRights objGroupDAL = new GetGroupRights();
            objGroupDAL.GroupID = GroupID;
            objGroupDAL.SubSystemID = SubSystemID;
            return objGroupDAL.ExecuteDataTable();
        }

        public static DataTable GetSelectBySubSystemIDAndParentID(int ParentID, string SubSystemID)
        {
            GroupSelectBySubSystemIDAndParentID objGroupDAL = new GroupSelectBySubSystemIDAndParentID();
            objGroupDAL.ParentGroupID = ParentID;
            objGroupDAL.SubSystemID = SubSystemID;
            return objGroupDAL.ExecuteDataTable();
        }

        public static DataTable GroupRights(string SubSystemID, int GroupID)
        {
            GetGroupRights objRightDAL = new GetGroupRights();
            objRightDAL.GroupID = GroupID;
            objRightDAL.SubSystemID = SubSystemID;
            return objRightDAL.ExecuteDataTable();
        }
        public static Group GetGroup(string SubSystemID, System.Int32 GroupID)
        {
            GroupSelectBySubSystemIDAndGroupID objGroupDAL = new GroupSelectBySubSystemIDAndGroupID();
            Group objGroup = new Group();
            objGroupDAL.GroupID = GroupID;
            objGroupDAL.SubSystemID = SubSystemID;
            objGroup.SetMetaDataTable(objGroupDAL.ExecuteDataTable());
            return objGroup;
        }

        public static void AddGroupRights(int GroupID, int RightID, int CreateUser)
        {

            Right_GroupInsert objGroupRightDAL = new Right_GroupInsert();
            objGroupRightDAL.GroupID = GroupID;
            objGroupRightDAL.RightID = RightID;
            objGroupRightDAL.CreateUser = CreateUser;
            objGroupRightDAL.ExecuteNonQuery();
        }

        public static void RemoveGroupRights(int GroupID, int RightID)
        {
            Right_GroupDelete objGroupRightDAL = new Right_GroupDelete();
            objGroupRightDAL.RightID = RightID;
            objGroupRightDAL.GroupID = GroupID;
            objGroupRightDAL.ExecuteNonQuery();
        }


	}
}