using System;
using System.Data;
using AVC.Passport.DataEntity;
using AVC.Passport.DataAccess;

namespace AVC.Passport
{
	public class Right_GroupBiz
	{
		public static void AddRight_Group(Right_Group objRight_Group)
		{
			Right_GroupInsert objRight_GroupDAL = new Right_GroupInsert();
			objRight_GroupDAL.ReceiveParameter(objRight_Group);
			objRight_GroupDAL.ExecuteNonQuery();
		}

		public static DataTable GetAllRight_Group()
		{
			Right_GroupSelectAll objRight_GroupDAL = new Right_GroupSelectAll();
			return objRight_GroupDAL.ExecuteDataTable();
		}

		public static void UpdateRight_Group(Right_Group objRight_Group)
		{
			Right_GroupUpdate objRight_GroupDAL = new Right_GroupUpdate();
			objRight_GroupDAL.ReceiveParameter(objRight_Group);
			objRight_GroupDAL.ExecuteNonQuery();
		}

		public static void DeleteRight_Group(System.Int32 GroupID,System.Int32 RightID)
		{
			Right_GroupDelete objRight_GroupDAL = new Right_GroupDelete();
			objRight_GroupDAL.GroupID = GroupID;
			objRight_GroupDAL.RightID = RightID;
			objRight_GroupDAL.ExecuteNonQuery();
		}

		public static Right_Group GetRight_Group(System.Int32 GroupID,System.Int32 RightID)
		{
			Right_GroupSelectByPk objRight_GroupDAL = new Right_GroupSelectByPk();
			Right_Group objRight_Group = new Right_Group();
			objRight_GroupDAL.GroupID = GroupID;
			objRight_GroupDAL.RightID = RightID;
			objRight_Group.SetMetaDataTable(objRight_GroupDAL.ExecuteDataTable());
			return objRight_Group;
		}

		public static DataTable GetRight_GroupByGroupID(System.Int32 GroupID)
		{
			Right_GroupSelectByGroupID objRight_GroupDAL = new Right_GroupSelectByGroupID();
			objRight_GroupDAL.GroupID = GroupID;
			return objRight_GroupDAL.ExecuteDataTable();
		}

		public static DataTable GetRight_GroupByRightID(System.Int32 RightID)
		{
			Right_GroupSelectByRightID objRight_GroupDAL = new Right_GroupSelectByRightID();
			objRight_GroupDAL.RightID = RightID;
			return objRight_GroupDAL.ExecuteDataTable();
		}
	}
}