﻿IF EXISTS (SELECT * FROM sysobjects WHERE type = 'P' AND name = 'GetGroupRights')
	BEGIN
		DROP  Procedure  GetGroupRights
	END

GO
/***********************************************
***功能描述：根据用户组/角色获取组/角色的权限
***传入传出参数：
***	@GroupID：类型：int，传入参数
***				   描述：要查询的组编号
***	@SubSystemID： 类型：varchar(6)，传入参数
***				   描述：子系统编号
***作者：
***建立时间:2009-1-6
***更改时间：
***更改人：
***更改原因：
	  ****************************************************/
CREATE PROCEDURE [dbo].[GetGroupRights]
	(
	@SubSystemID VARCHAR(6),
	@GroupID INT
	)
AS
SELECT Rights.RightID,Rights.RightName,Rights.RightDisplayName,RightType=RightsType.TypeName,RightTypeID,ParentGroup=[Group].GroupName,ParentGroupID=[Group].GroupID,RightMemo FROM Rights
	INNER JOIN Group_Right 
		ON Group_Right.RightID=Rights.RightID
	INNER JOIN RightsType
		ON RightsType.TypeID = Rights.RightTypeID
	INNER JOIN [Group]
		ON [Group].GroupID = Group_Right.GroupID
	WHERE  Group_Right.GroupID=@GroupID AND RightsType.SubSystemID=@SubSystemID