﻿IF EXISTS (SELECT * FROM sysobjects WHERE type = 'P' AND name = 'User_GroupAddDefault')
	BEGIN
		DROP  Procedure  User_GroupAddDefault
	END

GO
/***********************************************
***功能描述：为用户分配子系统的默认角色
***传入传出参数：
***	@UserID：用户编号
***	@CreateUser：操作员

***作者：
***建立时间:2009-1-6
***更改时间：
***更改人：
***更改原因：
****************************************************/
CREATE PROCEDURE User_GroupAddDefault
	(
		@UserID int,
		@CreateUser int
	)
AS
DECLARE @SubSystemID VARCHAR(6)
-- 先知道该用户是哪个子系统的
SELECT @SubSystemID=SubSystemID FROM UserMst WHERE UserID=@UserID

INSERT INTO [dbo].[User_Group](UserID, GroupID, CreateTime, CreateUser)
	SELECT @UserID,GroupID,GETDATE(), @CreateUser
		FROM [Group] 
			WHERE SubSystemID=@SubSystemID 
				AND IsDefault=1 
				AND GroupType=2
				AND NOT EXISTS(SELECT 1 FROM [dbo].[User_Group] WHERE UserID=@UserID AND GroupID=[Group].GroupID)
GO