﻿IF EXISTS (SELECT * FROM sysobjects WHERE type = 'P' AND name = 'User_GroupInsertA')
	BEGIN
		DROP  Procedure  User_GroupInsertA
	END

GO
/***********************************************
***功能描述：将用户加入到指定的组。加入前做一个判断，判断用户是否已成为该组成员
***传入传出参数：
***	@UserID：用户ID
***	@GroupID：要加入的组
***	@CreateUser：创建者

***作者：
***建立时间:2009-1-6
***更改时间：
***更改人：
***更改原因：
****************************************************/
CREATE PROCEDURE User_GroupInsertA
	(
		@UserID int,
		@GroupID int,
		@CreateUser int
	)
AS
IF NOT EXISTS(SELECT 1 FROM [User_Group] WHERE UserID=@UserID AND GroupID=@GroupID)
BEGIN
	INSERT INTO [dbo].[User_Group]
		(
		[UserID],
		[GroupID],
		[CreateTime],
		[CreateUser]
		)
	VALUES
		(
		@UserID,
		@GroupID,
		GETDATE(),
		@CreateUser
		)
END
GO