using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class UserLogInfoBiz
	{
		public static void AddUserLogInfo(UserLogInfo objUserLogInfo)
		{
			UserLogInfoInsert objUserLogInfoDAL = new UserLogInfoInsert();
			objUserLogInfoDAL.ReceiveParameter(objUserLogInfo);
			objUserLogInfoDAL.ExecuteNonQuery();
		}

		public static DataTable GetAllUserLogInfo()
		{
			UserLogInfoSelectAll objUserLogInfoDAL = new UserLogInfoSelectAll();
			return objUserLogInfoDAL.ExecuteDataTable();
		}

		public static void UpdateUserLogInfo(UserLogInfo objUserLogInfo)
		{
			UserLogInfoUpdate objUserLogInfoDAL = new UserLogInfoUpdate();
			objUserLogInfoDAL.ReceiveParameter(objUserLogInfo);
			objUserLogInfoDAL.ExecuteNonQuery();
		}

		public static void DeleteUserLogInfo(System.Int64 LogID)
		{
			UserLogInfoDelete objUserLogInfoDAL = new UserLogInfoDelete();
			objUserLogInfoDAL.LogID = LogID;
			objUserLogInfoDAL.ExecuteNonQuery();
		}

		public static UserLogInfo GetUserLogInfo(System.Int64 LogID)
		{
			UserLogInfoSelectByPk objUserLogInfoDAL = new UserLogInfoSelectByPk();
			UserLogInfo objUserLogInfo = new UserLogInfo();
			objUserLogInfoDAL.LogID = LogID;
			objUserLogInfo.SetMetaDataTable(objUserLogInfoDAL.ExecuteDataTable());
			return objUserLogInfo;
		}

		public static DataTable GetUserLogInfoBySubSystemID(System.String SubSystemID)
		{
			UserLogInfoSelectBySubSystemID objUserLogInfoDAL = new UserLogInfoSelectBySubSystemID();
			objUserLogInfoDAL.SubSystemID = SubSystemID;
			return objUserLogInfoDAL.ExecuteDataTable();
		}

		public static DataTable GetUserLogInfoByUserID(System.Int32 UserID)
		{
			UserLogInfoSelectByUserID objUserLogInfoDAL = new UserLogInfoSelectByUserID();
			objUserLogInfoDAL.UserID = UserID;
			return objUserLogInfoDAL.ExecuteDataTable();
		}
	}
}