using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class User_GroupBiz
	{
		public static void AddUser_Group(User_Group objUser_Group)
		{
			User_GroupInsert objUser_GroupDAL = new User_GroupInsert();
			objUser_GroupDAL.ReceiveParameter(objUser_Group);
			objUser_GroupDAL.ExecuteNonQuery();
		}

		public static DataTable GetAllUser_Group()
		{
			User_GroupSelectAll objUser_GroupDAL = new User_GroupSelectAll();
			return objUser_GroupDAL.ExecuteDataTable();
		}

		public static void UpdateUser_Group(User_Group objUser_Group)
		{
			User_GroupUpdate objUser_GroupDAL = new User_GroupUpdate();
			objUser_GroupDAL.ReceiveParameter(objUser_Group);
			objUser_GroupDAL.ExecuteNonQuery();
		}

		public static void DeleteUser_Group(System.Int32 UserID,System.Int32 GroupID)
		{
			User_GroupDelete objUser_GroupDAL = new User_GroupDelete();
			objUser_GroupDAL.UserID = UserID;
			objUser_GroupDAL.GroupID = GroupID;
			objUser_GroupDAL.ExecuteNonQuery();
		}

		public static User_Group GetUser_Group(System.Int32 UserID,System.Int32 GroupID)
		{
			User_GroupSelectByPk objUser_GroupDAL = new User_GroupSelectByPk();
			User_Group objUser_Group = new User_Group();
			objUser_GroupDAL.UserID = UserID;
			objUser_GroupDAL.GroupID = GroupID;
			objUser_Group.SetMetaDataTable(objUser_GroupDAL.ExecuteDataTable());
			return objUser_Group;
		}

		public static DataTable GetUser_GroupByGroupID(System.Int32 GroupID)
		{
			User_GroupSelectByGroupID objUser_GroupDAL = new User_GroupSelectByGroupID();
			objUser_GroupDAL.GroupID = GroupID;
			return objUser_GroupDAL.ExecuteDataTable();
		}

		public static DataTable GetUser_GroupByUserID(System.Int32 UserID)
		{
			User_GroupSelectByUserID objUser_GroupDAL = new User_GroupSelectByUserID();
			objUser_GroupDAL.UserID = UserID;
			return objUser_GroupDAL.ExecuteDataTable();
		}
	}
}