﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using AVC.Business;
using AVC.DataEntity;

public partial class Affiche_AfficheEdit : LoginPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if ((string)Request["Action"] == "Edit")
            {
                Affiche objAffiche = AfficheBiz.GetAffiche(int.Parse(Request["AfficheID"]));
                ViewState["AfficheID"] = (string)Request["AfficheID"];
                BindAfficheDate(objAffiche);
            }
            ViewState["Action"] = (string)Request["Action"];
        }
    }

    private void BindAfficheDate(Affiche objAffiche)
    {
        txtAfficheCaption.Text = objAffiche.Caption;
        txtAfficheContent.Text = objAffiche.AfficheContent;
   
    }
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        if ((string)ViewState["Action"] == "Add")
        {
            Affiche obj = new Affiche();
            obj.IssuanceDate = DateTime.Now;
            obj.AfficheContent = txtAfficheContent.Text;
            obj.Caption = txtAfficheCaption.Text;
            AfficheBiz.AddAffiche(obj);
        }
        else
        {
            Affiche obj = AfficheBiz.GetAffiche(int.Parse((string)ViewState["AfficheID"]));
            obj.AfficheContent = txtAfficheContent.Text;
            obj.Caption = txtAfficheCaption.Text;
            AfficheBiz.UpdateAffiche(obj);
        }
    }
}
