
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using AVC.Business;
using AVC.DataEntity;
public partial class BusOwnersList : LoginPageBase
		{
		protected void Page_Load(object sender, EventArgs e)
		{
		if (!IsPostBack)
		{
		ViewState["CurrentPage"] = 1;
        ViewState["Sort"] = "ID";
		BindData(1, "ID");
		}
		}
		private void BindData(int CurrentPage, string Sort)
		{
		int TotalPage = 0;//总页数
		int TotalRecord = 0;//总记录数
		int PageSize = int.Parse(txtPageSize.Text);//每页10条数据
		txtCurrentPage.Text = CurrentPage.ToString();//当前页
		dgResult.DataSource = BusOwnersBiz.GetBusOwnersSelectAllPaged(CurrentPage - 1, out TotalPage, out TotalRecord, PageSize, Sort);
		dgResult.DataBind();
		lblRecordCount.Text = TotalRecord.ToString();
		lblPageCount.Text = TotalPage.ToString();
		ViewState["Page"] = CurrentPage;
		ViewState["Sort"] = Sort;
		if (CurrentPage <= 1)
		{
		//如果当前页已经是第1页
		lbtnPrevious.Enabled = false;
		lbtnFirst.Enabled = false;
		lbtnNext.Enabled = true;
		lbtnLast.Enabled = true;
		ViewState["Page"] = 1;
		}
		else if (CurrentPage >= TotalPage)
		{//如果当前项已经是最末页
		lbtnFirst.Enabled = true;
		lbtnNext.Enabled = false;
		lbtnLast.Enabled = false;
		lbtnPrevious.Enabled = true;
		ViewState["Page"] = TotalPage;
		}
		else
		{
		lbtnFirst.Enabled = true;
		lbtnNext.Enabled = true;
		lbtnLast.Enabled = true;
		lbtnPrevious.Enabled = true;
		}
        if (TotalPage == 1)
        {
            lbtnFirst.Enabled = false;
            lbtnNext.Enabled = false;
            lbtnLast.Enabled = false;
            lbtnPrevious.Enabled = false;
        }
		}
		protected void btnGo_Click(object sender, EventArgs e)
		{
		if (ViewState["Sort"] == null)
		{
		BindData(int.Parse(txtCurrentPage.Text), "ID");
		}
		else
		{
		BindData(int.Parse(txtCurrentPage.Text), (string)ViewState["Sort"]);
		}
		}
		protected void dgResult_RowDataBound(object sender, GridViewRowEventArgs e)
		{

		}
		protected void lbtnFirst_Click(object sender, EventArgs e)
		{
		string Sort = (string)ViewState["Sort"];
		if (Sort != null)
		{
		BindData(1, Sort);
		}
		else
		{
		BindData(1, "ID");
		}
		}
		protected void lbtnLast_Click(object sender, EventArgs e)
		{
		string Sort = (string)ViewState["Sort"];
		int Page = int.Parse(lblPageCount.Text);
		if (Sort != null)
		{
		BindData(Page, Sort);
		}
		else
		{
		BindData(Page, "ID");
		}
		}
		protected void lbtnNext_Click(object sender, EventArgs e)
		{
		string Sort = (string)ViewState["Sort"];
		int Page = int.Parse(ViewState["Page"].ToString());
		Page++;
		if (Sort != null)
		{
		BindData(Page, Sort);
		}
		else
		{
		BindData(Page, "ID");
		}
		}
		protected void lbtnPrevious_Click(object sender, EventArgs e)
		{
		string Sort = (string)ViewState["Sort"];
		int Page = int.Parse(ViewState["Page"].ToString());
		Page--;
		if (Sort != null)
		{
		BindData(Page, Sort);
		}
		else
		{
		BindData(1, "ID");
		}
		}

		protected void dgResult_Sorting(object sender, GridViewSortEventArgs e)
		{
		if (e.SortExpression == (string)ViewState["Sort"])
		ViewState["Sort"] = e.SortExpression + " DESC";
		else
		ViewState["Sort"] = e.SortExpression;
		int CurrentPage = int.Parse(txtCurrentPage.Text);
		BindData(CurrentPage, (string)ViewState["Sort"]);
		}

		protected void dgResult_RowCommand(object sender, GridViewCommandEventArgs e)
		{
		if (e.CommandName == "Delete")
		{
		if (!string.IsNullOrEmpty((string)e.CommandArgument))
		{
		BusOwnersBiz.DeleteBusOwners(int.Parse(e.CommandArgument.ToString()));
        Alert("刪除成功！");
        string Sort = (string)ViewState["Sort"];
        int Page = int.Parse(ViewState["Page"].ToString());
        if (Sort != null)
        {
            BindData(Page, Sort);
        }
        else
        {
            BindData(1, "ID");
        }
 
		}

		}
		}
        protected void dgResult_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {

        }
        protected void dgResult_Sorting1(object sender, GridViewSortEventArgs e)
        {

        }
}
	