
using System;
using System.Data;
using System.Web.UI.WebControls;
using System.Web.SessionState;
using AVC.Business;
using AVC.DataEntity;

	/// <summary>
	/// Car编辑
	/// </summary>
public partial class CarEdit : LoginPageBase
	{

		private void Page_Load(object sender, System.EventArgs e)
		{
			if(!IsPostBack)
			{
                BindDropDownList();
				string strAction = Request.QueryString["action"];
				// 自动编号
				txtID.ReadOnly = true;
				txtID.Text = "自动增长";
				
				ViewState["Action"] = strAction;
				if(strAction == "edit")
				{
					System.Int32 ID = System.Int32.Parse(Request.QueryString["ID"]);Car objCar = CarBiz.GetCar(ID);
					
					txtID.Text = objCar.ID.ToString();
                    ddlOwners.SelectedItem.Value = objCar.OwnersID.ToString();
					txtCarLicense.Text = objCar.CarLicense;
					txtTransportCard.Text = objCar.TransportCard;
                    txtTransportCardIssueDate.Text = objCar.TransportCardIssueDate.ToString("yyyy-MM-dd");
                    txtTransportCardFromDate.Text = objCar.TransportCardFromDate.ToString("yyyy-MM-dd");
                    txtTransportCardToDate.Text = objCar.TransportCardToDate.ToString("yyyy-MM-dd");
                    ddlCarColor.SelectedValue  = objCar.CarColor;
					txtSeatNumber.Text = objCar.SeatNumber.ToString();
					txtEngine.Text = objCar.Engine;
					txtChassis.Text = objCar.Chassis;
					txtCarModel.Text = objCar.CarModel;
                    ddlFuel.SelectedItem.Value  = objCar.Fuel;
					txtAnnualDate.Text = objCar.AnnualDate;
					txtCarinessRightCard.Text = objCar.CarinessRightCard;
					txtCarinessRightCardIssueDate.Text = objCar.CarinessRightCardIssueDate.ToString("yyyy-MM-dd");
                    txtCarinessRightCardFromDate.Text = objCar.CarinessRightCardFromDate.ToString("yyyy-MM-dd");
                    txtCarinessRightCardToDate.Text = objCar.CarinessRightCardToDate.ToString("yyyy-MM-dd");
					txtOperateCard.Text = objCar.OperateCard;
                    txtOperateCardFromDate.Text = objCar.OperateCardFromDate.ToString("yyyy-MM-dd");
                    txtOperateCardToDate.Text = objCar.OperateCardToDate.ToString("yyyy-MM-dd");
                    txtOperateIssueDate.Text = objCar.OperateIssueDate.ToString("yyyy-MM-dd");
					txtID.ReadOnly = true;
					
				}
			}
		}
    private void BindDropDownList()
    {
        ddlOwners.DataSource = CarOwnersBiz.GetAllCarOwners();
        ddlOwners.DataBind();
        ddlCarColor.DataSource = OptionalValueBiz.GetOptionValueByDescription("color");
        ddlCarColor.DataBind();
        ddlFuel.DataSource = OptionalValueBiz.GetOptionValueByDescription("fuel");
        ddlFuel.DataBind();
    }
		public void btnOK_Click(object sender, System.EventArgs e)
		{
			try
			{
				if((string)ViewState["Action"] == "add")
				{
					Car objCar = new Car();

                    objCar.OwnersID = System.Int32.Parse(ddlOwners.SelectedItem.Value);
					objCar.CarLicense = txtCarLicense.Text;
					objCar.TransportCard = txtTransportCard.Text;
					objCar.TransportCardIssueDate = System.DateTime.Parse(txtTransportCardIssueDate.Text);
					objCar.TransportCardFromDate = System.DateTime.Parse(txtTransportCardFromDate.Text);
					objCar.TransportCardToDate = System.DateTime.Parse(txtTransportCardToDate.Text);
                    objCar.CarColor = ddlCarColor.SelectedItem.Value;
					objCar.SeatNumber = System.Int32.Parse(txtSeatNumber.Text);
					objCar.Engine = txtEngine.Text;
					objCar.Chassis = txtChassis.Text;
					objCar.CarModel = txtCarModel.Text;
					objCar.Fuel = ddlFuel.SelectedItem.Value;
					objCar.AnnualDate = txtAnnualDate.Text;
					objCar.CarinessRightCard = txtCarinessRightCard.Text;
					objCar.CarinessRightCardIssueDate = System.DateTime.Parse(txtCarinessRightCardIssueDate.Text);
					objCar.CarinessRightCardFromDate = System.DateTime.Parse(txtCarinessRightCardFromDate.Text);
					objCar.CarinessRightCardToDate = System.DateTime.Parse(txtCarinessRightCardToDate.Text);
					objCar.OperateCard = txtOperateCard.Text;
					objCar.OperateCardFromDate = System.DateTime.Parse(txtOperateCardFromDate.Text);
					objCar.OperateCardToDate = System.DateTime.Parse(txtOperateCardToDate.Text);
					objCar.OperateIssueDate = System.DateTime.Parse(txtOperateIssueDate.Text);
					ViewState["Action"] = "edit";		
					txtID.ReadOnly = true;			
					txtID.ReadOnly = true;
					txtID.Text = objCar.ID.ToString();
					
				}
				else if((string)ViewState["Action"] == "edit")
				{
					Car objCar = CarBiz.GetCar(System.Int32.Parse(txtID.Text));
					
					objCar.ID = System.Int32.Parse(txtID.Text);

                    objCar.OwnersID = System.Int32.Parse(ddlOwners.SelectedItem.Value);
					
					objCar.CarLicense = txtCarLicense.Text;
					
					objCar.TransportCard = txtTransportCard.Text;
					
					objCar.TransportCardIssueDate = System.DateTime.Parse(txtTransportCardIssueDate.Text);
					
					objCar.TransportCardFromDate = System.DateTime.Parse(txtTransportCardFromDate.Text);
					
					objCar.TransportCardToDate = System.DateTime.Parse(txtTransportCardToDate.Text);

                    objCar.CarColor = ddlCarColor.SelectedItem.Value;
					
					objCar.SeatNumber = System.Int32.Parse(txtSeatNumber.Text);
					
					objCar.Engine = txtEngine.Text;
					
					objCar.Chassis = txtChassis.Text;
					
					objCar.CarModel = txtCarModel.Text;
					
					objCar.Fuel = ddlFuel.SelectedItem.Value;
					
					objCar.AnnualDate = txtAnnualDate.Text;
					
					objCar.CarinessRightCard = txtCarinessRightCard.Text;
					
					objCar.CarinessRightCardIssueDate = System.DateTime.Parse(txtCarinessRightCardIssueDate.Text);
					
					objCar.CarinessRightCardFromDate = System.DateTime.Parse(txtCarinessRightCardFromDate.Text);
					
					objCar.CarinessRightCardToDate = System.DateTime.Parse(txtCarinessRightCardToDate.Text);
					
					objCar.OperateCard = txtOperateCard.Text;
					
					objCar.OperateCardFromDate = System.DateTime.Parse(txtOperateCardFromDate.Text);
					
					objCar.OperateCardToDate = System.DateTime.Parse(txtOperateCardToDate.Text);
					
					objCar.OperateIssueDate = System.DateTime.Parse(txtOperateIssueDate.Text);
					
					CarBiz.UpdateCar(objCar);
				}
				lblMessage.Text = "保存成功！";
			}
			catch(Exception ex)
			{
				lblMessage.Text = ex.Message;
			}
		}
	}
