
using System;
using System.Data;
using System.Web.UI.WebControls;
using System.Web.SessionState;
using AVC.Business;
using AVC.DataEntity;

	/// <summary>
	/// CarEmployee编辑
	/// </summary>
public partial class CarEmployeeEdit : LoginPageBase
	{

		private void Page_Load(object sender, System.EventArgs e)
		{
			if(!IsPostBack)
			{
				string strAction = Request.QueryString["action"];
				// 自动编号
                BindDropDownList();
				txtID.ReadOnly = true;
				txtID.Text = "自动增长";
				
				ViewState["Action"] = strAction;
				if(strAction == "edit")
				{
					System.Int32 ID = System.Int32.Parse(Request.QueryString["ID"]);CarEmployee objCarEmployee = CarEmployeeBiz.GetCarEmployee(ID);
					
					txtID.Text = objCarEmployee.ID.ToString();
					txtIDCard.Text = objCarEmployee.IDCard;
					txtName.Text = objCarEmployee.Name;
					ddlSex.Text = objCarEmployee.Sex.ToString();
					txtPhone.Text = objCarEmployee.Phone;
					txtLandscape.Text = objCarEmployee.Landscape;
					txtAddress.Text = objCarEmployee.Address;
					txtDriverLicenseNO.Text = objCarEmployee.DriverLicenseNO;
					ddlDriverLicenseNoVehicleType.SelectedItem.Value  = objCarEmployee.DriverLicenseNoVehicleType;
                    txtDriverLicenseNoIssueDate.Text = objCarEmployee.DriverLicenseNoIssueDate.ToString("yyyy-MM-dd");
					txtBirthDay.Text = objCarEmployee.BirthDay.ToString();
                    //txtPhoto.Text = objCarEmployee.Photo.ToString();
					txtServiceUnit.Text = objCarEmployee.ServiceUnit;
                    ddlEducation.SelectedItem.Value = objCarEmployee.Education;
					txtServiceCardNO.Text = objCarEmployee.ServiceCardNO;
                    txtServiceCardNOFromDate.Text = objCarEmployee.ServiceCardNOFromDate.ToString("yyyy-MM-dd");
                    txtServiceCardNOToDate.Text = objCarEmployee.ServiceCardNOToDate.ToString("yyyy-MM-dd");
					ddlCarID.SelectedItem.Value  = objCarEmployee.CarID.ToString();
					txtID.ReadOnly = true;
					
				}
			}
		}

    private void BindDropDownList()
    {
        ddlCarID.DataSource = CarBiz.GetAllCar();
        ddlCarID.DataBind();
        ddlDriverLicenseNoVehicleType.DataSource = OptionalValueBiz.GetOptionValueByDescription("DriverLicenseNoVehicleType");
        ddlDriverLicenseNoVehicleType.DataBind();
        ddlEducation.DataSource = OptionalValueBiz.GetOptionValueByDescription("Education");
        ddlEducation.DataBind();
        
    }

		public void btnOK_Click(object sender, System.EventArgs e)
		{
			try
			{
				if((string)ViewState["Action"] == "add")
				{
					CarEmployee objCarEmployee = new CarEmployee();
					
					objCarEmployee.IDCard = txtIDCard.Text;
					objCarEmployee.Name = txtName.Text;
					objCarEmployee.Sex = System.Boolean.Parse(ddlSex.SelectedItem.Value);
					objCarEmployee.Phone = txtPhone.Text;
					objCarEmployee.Landscape = txtLandscape.Text;
					objCarEmployee.Address = txtAddress.Text;
					objCarEmployee.DriverLicenseNO = txtDriverLicenseNO.Text;
                    objCarEmployee.DriverLicenseNoVehicleType = ddlDriverLicenseNoVehicleType.SelectedItem.Value;
					objCarEmployee.DriverLicenseNoIssueDate = System.DateTime.Parse(txtDriverLicenseNoIssueDate.Text);
					objCarEmployee.BirthDay = System.DateTime.Parse(txtBirthDay.Text);
                    //objCarEmployee.Photo = System.Byte[].Parse(txtPhoto.Text);
					objCarEmployee.ServiceUnit = txtServiceUnit.Text;
                    objCarEmployee.Education = ddlEducation.SelectedItem.Value;
					objCarEmployee.ServiceCardNO = txtServiceCardNO.Text;
					objCarEmployee.ServiceCardNOFromDate = System.DateTime.Parse(txtServiceCardNOFromDate.Text);
					objCarEmployee.ServiceCardNOToDate = System.DateTime.Parse(txtServiceCardNOToDate.Text);
					objCarEmployee.CarID = System.Int32.Parse(ddlCarID.SelectedItem.Value);
                    objCarEmployee.CreateUser = UserName;
                    objCarEmployee.UpdateDateTime = DateTime.Now;
                    objCarEmployee.UpdateUser = UserName;
                    objCarEmployee.Flag = 1;
                    objCarEmployee.FlagDateTime = DateTime.Now;
				    CarEmployeeBiz.AddCarEmployee(objCarEmployee);
					ViewState["Action"] = "edit";
					txtID.ReadOnly = true;
					
					txtID.ReadOnly = true;
					txtID.Text = objCarEmployee.ID.ToString();
					
				}
				else if((string)ViewState["Action"] == "edit")
				{
					CarEmployee objCarEmployee = CarEmployeeBiz.GetCarEmployee(System.Int32.Parse(txtID.Text));
					
					objCarEmployee.ID = System.Int32.Parse(txtID.Text);
					
					objCarEmployee.IDCard = txtIDCard.Text;
					
					objCarEmployee.Name = txtName.Text;
					
					objCarEmployee.Sex = System.Boolean.Parse(ddlSex.SelectedItem.Value);
					
					objCarEmployee.Phone = txtPhone.Text;
					
					objCarEmployee.Landscape = txtLandscape.Text;
					
					objCarEmployee.Address = txtAddress.Text;
					
					objCarEmployee.DriverLicenseNO = txtDriverLicenseNO.Text;

                    objCarEmployee.DriverLicenseNoVehicleType = ddlDriverLicenseNoVehicleType.SelectedItem.Value ;
					
					objCarEmployee.DriverLicenseNoIssueDate = System.DateTime.Parse(txtDriverLicenseNoIssueDate.Text);
					
					objCarEmployee.BirthDay = System.DateTime.Parse(txtBirthDay.Text);
					
                    //objCarEmployee.Photo = System.Byte[].Parse(txtPhoto.Text);
					
					objCarEmployee.ServiceUnit = txtServiceUnit.Text;

                    objCarEmployee.Education = ddlEducation.SelectedItem.Value;
					
					objCarEmployee.ServiceCardNO = txtServiceCardNO.Text;
					
					objCarEmployee.ServiceCardNOFromDate = System.DateTime.Parse(txtServiceCardNOFromDate.Text);
					
					objCarEmployee.ServiceCardNOToDate = System.DateTime.Parse(txtServiceCardNOToDate.Text);
					
					objCarEmployee.CarID = System.Int32.Parse(ddlCarID.SelectedItem.Value);

                    objCarEmployee.UpdateDateTime = DateTime.Now;

                    objCarEmployee.UpdateUser = UserName;

    				CarEmployeeBiz.UpdateCarEmployee(objCarEmployee);
				}
				lblMessage.Text = "保存成功！";
			}
			catch(Exception ex)
			{
				lblMessage.Text = ex.Message;
			}
		}
	}
