﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Xml;


public partial class Menu : System.Web.UI.Page
{
	protected void Page_Load(object sender, EventArgs e)
	{
		#region 定义局部变量
		TreeNode tvnParent = null;
		TreeNode tvnChild = null;
		XmlNode xmlParent = null;
		XmlNode xmlChild = null;
		XmlNodeList nodeParents = null;
		#endregion

		#region 加载树菜单文件
		XmlDocument xmlMenu = new XmlDocument();

		string strHostName = Request.Url.Host.ToLower();
		xmlMenu.Load(Server.MapPath("TreeMenu.xml"));

		// 获取父节点的集合
		string Target = xmlMenu.DocumentElement.Attributes["Target"].Value;
		bool IsNodeExpanded = bool.Parse(xmlMenu.DocumentElement.Attributes["Expanded"].Value);

		if (Request.Browser.Browser != "IE")
			IsNodeExpanded = true;
		else
		{
			if (Request.Browser.MajorVersion < 6)
				IsNodeExpanded = true;
		}

		TreeNodeStyle cssParentDefaultStyle = new TreeNodeStyle();
		TreeNodeStyle cssChildrenDefaultStyle = new TreeNodeStyle();
		cssParentDefaultStyle.CssClass = xmlMenu.DocumentElement.Attributes["ParentCssStyle"].Value;
		cssChildrenDefaultStyle.CssClass = xmlMenu.DocumentElement.Attributes["ChildrenCssStyle"].Value;
		trvMenu.LevelStyles.Add(cssParentDefaultStyle);
		trvMenu.LevelStyles.Add(cssChildrenDefaultStyle);


		if (Target != "" && Target != null)
			trvMenu.Target = Target;

		nodeParents = xmlMenu.DocumentElement.ChildNodes;
		for (int i = 0; i < nodeParents.Count; i++)
		{
			// 获取父节点
			xmlParent = nodeParents[i];

			// 新建父节点
			tvnParent = new TreeNode();
			tvnParent.Text = xmlParent.Attributes["Text"].Value;
			if (xmlParent.ChildNodes.Count != 0)
				tvnParent.NavigateUrl = xmlParent.ChildNodes[0].Attributes["NavigateUrl"].Value;
			else
				//if(xmlParent.Attributes["NavigateUrl"].Value != null && xmlParent.Attributes["NavigateUrl"].Value != "")
				tvnParent.NavigateUrl = xmlParent.Attributes["NavigateUrl"].Value;
			if (xmlParent.Attributes["Target"].Value != null && xmlParent.Attributes["Target"].Value != "")
				tvnParent.Target = xmlParent.Attributes["Target"].Value;
			if (xmlParent.Attributes["ImageUrl"].Value != null && xmlParent.Attributes["ImageUrl"].Value != "")
				tvnParent.ImageUrl = xmlParent.Attributes["ImageUrl"].Value;
			tvnParent.Expanded = IsNodeExpanded;


			//获取子节点
			bool ParentRight = xmlParent.ChildNodes.Count == 0;
			for (int j = 0; j < xmlParent.ChildNodes.Count; j++)
			{
				xmlChild = xmlParent.ChildNodes[j];

				// 获取子节点需要的权限
				string Rights = xmlChild.Attributes["Rights"].Value;
				//if (CheckOneRight(Rights.Split(',')) || Rights == "")
				//{
				// 新建子节点
				tvnChild = new TreeNode();
				tvnChild.Text = xmlChild.Attributes["Text"].Value;
				if (xmlChild.Attributes["NavigateUrl"].Value != null && xmlChild.Attributes["NavigateUrl"].Value != "")
					tvnChild.NavigateUrl = xmlChild.Attributes["NavigateUrl"].Value;
				if (xmlChild.Attributes["Target"].Value != null && xmlChild.Attributes["Target"].Value != "")
					tvnChild.Target = xmlChild.Attributes["Target"].Value;
				if (xmlChild.Attributes["ImageUrl"].Value != null && xmlChild.Attributes["ImageUrl"].Value != "")
					tvnChild.ImageUrl = xmlChild.Attributes["ImageUrl"].Value;
				//						tvnChild.DefaultStyle = cssChildrenDefaultStyle;

				tvnParent.ChildNodes.Add(tvnChild);
				ParentRight = true;
				//}
			}

			// 如果用户具有父节点下的任何一个节点的访问权，则显示父节点。
			if (ParentRight)
				trvMenu.Nodes.Add(tvnParent);
		}
		#endregion

		// 设为首页
		tvnParent = new TreeNode();
		tvnParent.Text = "设为首页";
		tvnParent.ImageUrl = @"images\tree\tree12.gif";
		//			tvnParent.DefaultStyle = cssParentDefaultStyle;
		tvnParent.NavigateUrl = "javascript:SetHomePage('http://" + Request.Url.Host + "');";
		tvnParent.Target = "_self";
		trvMenu.Nodes.Add(tvnParent);

		// 加入收藏夹
		tvnParent = new TreeNode();
		tvnParent.Text = "加入收藏夹";
		tvnParent.ImageUrl = @"images\tree\tree13.gif";
		//			tvnParent.DefaultStyle = cssParentDefaultStyle;
		tvnParent.NavigateUrl = "javascript:window.external.addFavorite('http://" + Request.Url.Host + "','城市運政管理');";
		trvMenu.Nodes.Add(tvnParent);
	}
}
