
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using AVC.Passport;
using AVC.Passport.DataEntity;
public partial class GroupList : LoginPageBase
		{
		protected void Page_Load(object sender, EventArgs e)
		{
		if (!IsPostBack)
		{

        string strSubSystemID = Request.QueryString["subsystemid"] + "";
        ViewState["SubSystemID"] = "SYS002";

        string strParentID = Request.QueryString["parentid"] + "";
        int intParentID;
        int.TryParse(strParentID, out intParentID);

        ViewState["ParentID"] = intParentID;

		ViewState["CurrentPage"] = 1;
		ViewState["Sort"] = "GroupID";
	
		BindData(1, "GroupID");
		}
		}
		private void BindData(int CurrentPage, string Sort)
		{
		int TotalPage = 0;//总页数
		int TotalRecord = 0;//总记录数
		int PageSize = int.Parse(txtPageSize.Text);//每页10条数据
		txtCurrentPage.Text = CurrentPage.ToString();//当前页
		dgResult.DataSource = GroupBiz.GetGroupSelectAllPaged(CurrentPage - 1, out TotalPage, out TotalRecord, PageSize, Sort);
		dgResult.DataBind();
		lblRecordCount.Text = TotalRecord.ToString();
		lblPageCount.Text = TotalPage.ToString();
		ViewState["Page"] = CurrentPage;
		ViewState["Sort"] = Sort;
		if (CurrentPage <= 1)
		{
		//如果当前页已经是第1页
		lbtnPrevious.Enabled = false;
		lbtnFirst.Enabled = false;
		lbtnNext.Enabled = true;
		lbtnLast.Enabled = true;
		ViewState["Page"] = 1;
		}
		else if (CurrentPage >= TotalPage)
		{//如果当前项已经是最末页
		lbtnFirst.Enabled = true;
		lbtnNext.Enabled = false;
		lbtnLast.Enabled = false;
		lbtnPrevious.Enabled = true;
		ViewState["Page"] = TotalPage;
		}
		else
		{
		lbtnFirst.Enabled = true;
		lbtnNext.Enabled = true;
		lbtnLast.Enabled = true;
		lbtnPrevious.Enabled = true;
		}
        if (TotalPage == 1)
        {
            lbtnFirst.Enabled = false;
            lbtnNext.Enabled = false;
            lbtnLast.Enabled = false;
            lbtnPrevious.Enabled = false;
        }
		}
		protected void btnGo_Click(object sender, EventArgs e)
		{
		if (ViewState["Sort"] == null)
		{
		BindData(int.Parse(txtCurrentPage.Text), "GroupID");
		}
		else
		{
		BindData(int.Parse(txtCurrentPage.Text), (string)ViewState["Sort"]);
		}
		}
		protected void dgResult_RowDataBound(object sender, GridViewRowEventArgs e)
		{

		}
		protected void lbtnFirst_Click(object sender, EventArgs e)
		{
		string Sort = (string)ViewState["Sort"];
		if (Sort != null)
		{
		BindData(1, Sort);
		}
		else
		{
		BindData(1, "GroupID");
		}
		}
		protected void lbtnLast_Click(object sender, EventArgs e)
		{
		string Sort = (string)ViewState["Sort"];
		int Page = int.Parse(lblPageCount.Text);
		if (Sort != null)
		{
		BindData(Page, Sort);
		}
		else
		{
		BindData(Page, "GroupID");
		}
		}
		protected void lbtnNext_Click(object sender, EventArgs e)
		{
		string Sort = (string)ViewState["Sort"];
		int Page = int.Parse(ViewState["Page"].ToString());
		Page++;
		if (Sort != null)
		{
		BindData(Page, Sort);
		}
		else
		{
		BindData(Page, "GroupID");
		}
		}
		protected void lbtnPrevious_Click(object sender, EventArgs e)
		{
		string Sort = (string)ViewState["Sort"];
		int Page = int.Parse(ViewState["Page"].ToString());
		Page--;
		if (Sort != null)
		{
		BindData(Page, Sort);
		}
		else
		{
		BindData(1, "GroupID");
		}
		}
        /// <summary>
        /// 查询数据，只改变这里的方法
        /// </summary>
        /// <returns>包含查询结果的数据集</returns>


		protected void dgResult_Sorting(object sender, GridViewSortEventArgs e)
		{
		if (e.SortExpression == (string)ViewState["Sort"])
		ViewState["Sort"] = e.SortExpression + " DESC";
		else
		ViewState["Sort"] = e.SortExpression;
		int CurrentPage = int.Parse(txtCurrentPage.Text);
		BindData(CurrentPage, (string)ViewState["Sort"]);
		}

		protected void dgResult_RowCommand(object sender, GridViewCommandEventArgs e)
		{
		if (e.CommandName == "Delete")
		{
		if (!string.IsNullOrEmpty((string)e.CommandArgument))
		{
		GroupBiz.DeleteGroup(int.Parse(e.CommandArgument.ToString()),"SYS002");
		Alert("刪除成功！");
		string Sort = (string)ViewState["Sort"];
		int Page = int.Parse(ViewState["Page"].ToString());
		Alert("刪除成功");
		if (Sort != null)
		{
		BindData(Page, Sort);
		}
		else
		{
		BindData(1, "GroupID");
		}
		}
		}
     
		}
		protected void dgResult_RowDeleting(object sender, GridViewDeleteEventArgs e)
		{

		}

		}
	